/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.controller;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;

public class ControllerRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/controller/ControllerRenameProcessor", "canProcessElement"));
        }
        if (!(element instanceof GrClassDefinition)) {
            return false;
        }
        return GrailsArtifact.CONTROLLER.isInstance((PsiClass)((GrClassDefinition)element));
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PsiDirectory directory;
        String suffix = GrailsArtifact.CONTROLLER.suffix;
        if (!newName.endsWith(suffix) || newName.length() <= suffix.length()) {
            return;
        }
        String newControllerName = GrailsArtifact.CONTROLLER.getArtifactName(newName);
        VirtualFile oldViewsDir = GrailsUtils.getControllerGspDir((PsiClass)element);
        if (oldViewsDir != null && (directory = element.getManager().findDirectory(oldViewsDir)) != null) {
            allRenames.put((PsiElement)directory, newControllerName);
        }
    }
}

