/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.constraints;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GrailsConstraintsUtil {
    public static final Object CONSTRAINT_METHOD_MARKER = "Grails:Constraint:method";
    public static final String GRAILS_GORM_DEFAULT_CONSTRAINTS = "grails.gorm.default.constraints";

    private GrailsConstraintsUtil() {
    }

    public static boolean isConstraintsMethod(@Nullable PsiElement method) {
        return GrLightMethodBuilder.checkKind((PsiElement)method, (Object)CONSTRAINT_METHOD_MARKER);
    }

    public static boolean processImportFromMethod(PsiScopeProcessor processor, ResolveState state, @NotNull PsiElement context, String nameHint) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsUtil", "processImportFromMethod"));
        }
        if (nameHint != null && !nameHint.equals("importFrom")) {
            return true;
        }
        GrLightMethodBuilder importFromMethod = new GrLightMethodBuilder(context.getManager(), "importFrom");
        importFromMethod.addParameter("map", "java.util.Map", true);
        importFromMethod.addParameter("clazz", "java.lang.Class", false);
        THashMap map2 = new THashMap();
        map2.put("include", NamedArgumentDescriptor.TYPE_LIST);
        map2.put("exclude", NamedArgumentDescriptor.TYPE_LIST);
        importFromMethod.setNamedParameters((Map)map2);
        return processor.execute((PsiElement)importFromMethod, state);
    }

    public static PsiMethod createMethod(String name, PsiElement navigationElement, @Nullable PsiType valueType, @Nullable PsiClass validatedClass) {
        GrLightMethodBuilder res = new GrLightMethodBuilder(navigationElement.getManager(), name);
        res.addParameter("constraints", "java.util.Map", true);
        res.setNavigationElement(navigationElement);
        res.setMethodKind(CONSTRAINT_METHOD_MARKER);
        res.setData((Object)Pair.create((Object)valueType, (Object)validatedClass));
        return res;
    }

    @Nullable
    public static PsiClass getValidatedClass(@Nullable PsiElement constraintMethod) {
        Pair data = (Pair)GrLightMethodBuilder.getData((PsiElement)constraintMethod, (Object)CONSTRAINT_METHOD_MARKER);
        return data != null ? (PsiClass)data.second : null;
    }

    @Nullable
    public static PsiType getValidatedValueType(@Nullable PsiElement constraintMethod) {
        Pair data = (Pair)GrLightMethodBuilder.getData((PsiElement)constraintMethod, (Object)CONSTRAINT_METHOD_MARKER);
        return data != null ? (PsiType)data.first : null;
    }
}

