/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class TemplateFileReferenceSet
extends PluginSupportFileReferenceSet {
    private static final Pattern TEMPLATE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private static final String WEB_APP = "web-app";
    private final String myControllerName;
    private final GspTagWrapper myTagWrapper;

    public TemplateFileReferenceSet(@Nullable String controllerName, @NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed, @Nullable GspTagWrapper tagWrapper) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, false);
        this.myControllerName = controllerName;
        this.myTagWrapper = tagWrapper;
        this.reparse();
    }

    @Nullable
    private FileReference getContextPathReference() {
        if (this.myTagWrapper == null) {
            return null;
        }
        PsiElement contextPathElement = this.myTagWrapper.getAttributeValue("contextPath");
        if (contextPathElement != null) {
            for (PsiReference ref : contextPathElement.getReferences()) {
                if (!(ref instanceof FileReference)) continue;
                return ((FileReference)ref).getLastFileReference();
            }
        }
        return null;
    }

    @Override
    public PluginSupportFileReferenceSet.MyFileReference createNonPluginFileReference(TextRange range, int index, String text) {
        FileReference contextPathRef;
        FileReference prevRef = null;
        if (index == 0 && (contextPathRef = this.getContextPathReference()) instanceof PluginSupportFileReferenceSet.PluginDirReference) {
            prevRef = contextPathRef;
        }
        return new TmplFileReference(range, index, text, this, prevRef);
    }

    private void addRoot(List<PsiFileSystemItem> res, VirtualFile root) {
        if (!this.isAbsolutePathReference() && this.myControllerName != null && (root = root.findChild(this.myControllerName)) == null) {
            return;
        }
        PsiDirectory dir = this.getElement().getManager().findDirectory(root);
        if (dir == null) {
            return;
        }
        res.add((PsiFileSystemItem)dir);
    }

    private void addRootAndGrailsApp(List<PsiFileSystemItem> res, @Nullable VirtualFile root) {
        if (root != null) {
            VirtualFile webAppRoot;
            VirtualFile viewDir;
            VirtualFile grailsApp = root.findChild("grails-app");
            if (grailsApp != null && (viewDir = grailsApp.findChild("views")) != null) {
                this.addRoot(res, viewDir);
            }
            if ((webAppRoot = root.findChild(WEB_APP)) != null) {
                this.addRoot(res, webAppRoot);
            }
            this.addRoot(res, root);
        }
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement pluginElement;
        VirtualFile file = this.getElement().getContainingFile().getOriginalFile().getVirtualFile();
        if (file == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "computeDefaultContexts"));
            }
            return list;
        }
        ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>();
        PsiElement psiElement = pluginElement = this.myTagWrapper == null ? null : this.myTagWrapper.getAttributeValue("plugin");
        if (pluginElement != null) {
            PsiDirectory psiPluginRoot;
            PsiReference pluginRef = pluginElement.getReference();
            if (pluginRef != null && (psiPluginRoot = (PsiDirectory)pluginRef.resolve()) != null) {
                this.addRootAndGrailsApp(res, psiPluginRoot.getVirtualFile());
            }
            ArrayList<PsiFileSystemItem> arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "computeDefaultContexts"));
            }
            return arrayList;
        }
        FileReference contextPathRef = this.getContextPathReference();
        if (contextPathRef != null) {
            if (contextPathRef instanceof PluginSupportFileReferenceSet.PluginDirReference) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "computeDefaultContexts"));
                }
                return list;
            }
            for (ResolveResult resolveResult : contextPathRef.multiResolve(false)) {
                PsiElement item = resolveResult.getElement();
                if (!(item instanceof PsiFileSystemItem)) continue;
                this.addRootAndGrailsApp(res, ((PsiFileSystemItem)item).getVirtualFile());
            }
            ArrayList<PsiFileSystemItem> arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "computeDefaultContexts"));
            }
            return arrayList;
        }
        VirtualFile root = GrailsUtils.findParent(file, "grails-app");
        if (root != null) {
            root = root.getParent();
        }
        this.addRootAndGrailsApp(res, root);
        ArrayList<PsiFileSystemItem> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "computeDefaultContexts"));
        }
        return arrayList;
    }

    @Override
    protected boolean isAcceptToCompletion(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet", "isAcceptToCompletion"));
        }
        return super.isAcceptToCompletion(fileOrDir) || GrailsUtils.getTemplateName(fileOrDir.getName()) != null;
    }

    private static class TmplFileReference
    extends PluginSupportFileReferenceSet.MyFileReference {
        private final FileReference previousRef;

        public TmplFileReference(TextRange range, int index, String text, FileReferenceSet set, FileReference previousRef) {
            super(set, range, index, text);
            this.previousRef = previousRef;
        }

        @Override
        public FileReference getPreviousReference() {
            if (this.previousRef != null) {
                return this.previousRef;
            }
            return super.getPreviousReference();
        }

        public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result2, boolean caseSensitive) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference", "innerResolveInContext"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference", "innerResolveInContext"));
            }
            super.innerResolveInContext(this.isLast() ? GrailsUtils.getFileNameByTemplateName(text) : text, context, result2, caseSensitive);
        }

        protected Object createLookupItem(PsiElement candidate) {
            if (candidate instanceof GspFile) {
                PsiFile file = (PsiFile)candidate;
                String templateName = GrailsUtils.getTemplateName(file.getName());
                assert (templateName != null);
                return LookupElementBuilder.create((String)templateName).withIcon(file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        @Override
        @Nullable
        protected String pathToString(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference", "pathToString"));
            }
            int index = path.lastIndexOf(47);
            if (index == -1) {
                return GrailsUtils.getTemplateName(path);
            }
            String templateName = GrailsUtils.getTemplateName(path.substring(index + 1));
            if (templateName == null) {
                return null;
            }
            return path.substring(0, index + 1) + templateName;
        }

        public LocalQuickFix[] getQuickFixes() {
            if (!this.isLast()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String text = this.getText();
            if (!TEMPLATE_NAME_PATTERN.matcher(text).matches()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            VirtualFile context = null;
            for (PsiFileSystemItem item : this.getContexts()) {
                VirtualFile virtualFile = item.getVirtualFile();
                if (virtualFile == null || !virtualFile.isDirectory()) continue;
                if (context == null) {
                    context = virtualFile;
                    continue;
                }
                if (VfsUtilCore.isAncestor((VirtualFile)context, (VirtualFile)virtualFile, (boolean)false)) {
                    context = virtualFile;
                    continue;
                }
                if (VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)context, (boolean)false) || virtualFile.getName().equals(TemplateFileReferenceSet.WEB_APP)) continue;
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (context == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            final String templateName = GrailsUtils.getFileNameByTemplateName(text);
            final VirtualFile finalContext = context;
            return new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = "Create template '" + templateName + "'";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference$1", "getFamilyName"));
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    VirtualFile createdFile;
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference$1", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference$1", "applyFix"));
                    }
                    try {
                        createdFile = finalContext.createChildData((Object)project, templateName);
                    }
                    catch (IOException ignored) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(createdFile);
                    if (psiFile == null) {
                        return;
                    }
                    psiFile.navigate(true);
                }
            }};
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if (this.isLast()) {
                String string = "Cannot resolve template '_" + this.getCanonicalText() + ".gsp'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference", "getUnresolvedMessagePattern"));
                }
                return string;
            }
            String string = super.getUnresolvedMessagePattern();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

