/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.common.GrailsFileReferenceSetBase;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsViewFileReferenceSet
extends GrailsFileReferenceSetBase {
    private final Function<VirtualFile, VirtualFile> myContextFinder;

    public GrailsViewFileReferenceSet(@Nullable Function<VirtualFile, VirtualFile> contextFinder, @NotNull String str, PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed);
        this.myContextFinder = contextFinder;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new Condition<PsiFileSystemItem>(){
            private final ProjectFileIndex fileIndex;
            {
                this.fileIndex = ProjectRootManager.getInstance((Project)GrailsViewFileReferenceSet.this.getElement().getProject()).getFileIndex();
            }

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                if (psiFileSystemItem instanceof PsiDirectory) {
                    VirtualFile file = psiFileSystemItem.getVirtualFile();
                    return file != null && this.fileIndex.isInContent(file);
                }
                String name = psiFileSystemItem.getName();
                return name.endsWith(".gsp") || name.endsWith(".jsp");
            }
        };
    }

    @Override
    @Nullable
    protected VirtualFile getDefaultContext(boolean isAbsolute) {
        VirtualFile viewDir = GrailsUtils.findViewsDirectory(this.getElement());
        if (isAbsolute) {
            return viewDir;
        }
        if (viewDir == null) {
            return null;
        }
        if (this.myContextFinder == null) {
            return null;
        }
        return (VirtualFile)this.myContextFinder.fun((Object)viewDir);
    }

    @Override
    public GrailsFileReferenceSetBase.RenamableFileReference createFileReference(TextRange range, int index, String text) {
        return new GrailsFileReferenceSetBase.RenamableFileReference(this, range, index, text){

            protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result2, boolean caseSensitive) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$2", "innerResolveInContext"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$2", "innerResolveInContext"));
                }
                int size = result2.size();
                super.innerResolveInContext(this.isLast() ? text + ".gsp" : text, context, result2, caseSensitive);
                if (result2.size() == size) {
                    super.innerResolveInContext(this.isLast() ? text + ".jsp" : text, context, result2, caseSensitive);
                }
            }

            protected Object createLookupItem(PsiElement candidate) {
                if (candidate instanceof PsiFile) {
                    PsiFile file = (PsiFile)candidate;
                    String name = file.getName();
                    int idx = name.lastIndexOf(46);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    return LookupElementBuilder.create((String)name).withIcon(file.getIcon(0));
                }
                return super.createLookupItem(candidate);
            }

            protected PsiElement rename(String newName) throws IncorrectOperationException {
                if (newName.endsWith(".gsp") || newName.endsWith(".jsp")) {
                    newName = newName.substring(0, newName.length() - 4);
                }
                return super.rename(newName);
            }
        };
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element, @Nullable Function<VirtualFile, VirtualFile> contextFinder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        GrailsViewFileReferenceSet set = new GrailsViewFileReferenceSet(contextFinder, trimedUrl, element, offset, null, true, true);
        return set.getAllReferences();
    }

    public static class Provider
    implements GroovyNamedArgumentReferenceProvider {
        public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult method, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$Provider", "createRef"));
            }
            if (namedArgument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$Provider", "createRef"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$Provider", "createRef"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$Provider", "createRef"));
            }
            return GrailsViewFileReferenceSet.createReferences(element, (Function<VirtualFile, VirtualFile>)((Function)viewDir -> {
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/common/GrailsViewFileReferenceSet$Provider", "lambda$createRef$0"));
                }
                PsiClass aClass = PsiUtil.getContainingNotInnerClass((PsiElement)namedArgument);
                if (GrailsArtifact.CONTROLLER.isInstance(aClass)) {
                    return viewDir.findChild(GrailsArtifact.CONTROLLER.getArtifactName(aClass));
                }
                return null;
            }));
        }
    }
}

