/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.buildConfig;

import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GrailsRootBasedFileReferenceSet;
import org.jetbrains.plugins.grails.util.GrailsPatterns;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyAssignmentExpressionPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;

public class BuildConfigFileReferenceProvider
extends PsiReferenceProvider {
    private static final Set<String> SUPPORT_PROPERTIES = ContainerUtil.newHashSet((Object[])new String[]{"grails.work.dir", "grails.project.work.dir", "grails.project.war.exploded.dir", "grails.project.plugins.dir", "grails.global.plugins.dir", "grails.project.resource.dir", "grails.project.source.dir", "grails.project.web.xml", "grails.project.class.dir", "grails.project.plugin.class.dir", "grails.project.test.class.dir", "grails.project.test.reports.dir", "grails.project.docs.output.dir", "grails.project.test.source.dir", "grails.project.target.dir", "grails.project.war.file", "grails.war.destFile"});

    private static boolean isInlinePluginReference(GrReferenceExpression ref) {
        GrExpression expression = ref.getQualifierExpression();
        if (expression != null) {
            return "grails.plugin.location".equals(expression.getText());
        }
        return false;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/buildConfig/BuildConfigFileReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/buildConfig/BuildConfigFileReferenceProvider", "getReferencesByElement"));
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)element.getParent();
        GrExpression left = assignmentExpression.getLValue();
        if (!(left instanceof GrReferenceExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/buildConfig/BuildConfigFileReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = left.getText();
        if (!SUPPORT_PROPERTIES.contains(text) && !BuildConfigFileReferenceProvider.isInlinePluginReference((GrReferenceExpression)left)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/buildConfig/BuildConfigFileReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = GrailsRootBasedFileReferenceSet.createReferences(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/buildConfig/BuildConfigFileReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static void register(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)GroovyPatterns.rightOfAssignment((ElementPattern)GroovyPatterns.stringLiteral(), (GroovyAssignmentExpressionPattern)((GroovyAssignmentExpressionPattern)GroovyPatterns.groovyAssignmentExpression().withParent(GrailsPatterns.buildConfig()))), (PsiReferenceProvider)new BuildConfigFileReferenceProvider());
    }
}

