/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.resources;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GrailsResourceReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public GrailsResourceReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourceReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourceReferenceSearcher", "processQuery"));
        }
        PsiMethod elementToSearch = queryParameters.getMethod();
        if (!GrLightMethodBuilder.checkKind((PsiElement)elementToSearch, (Object)"grails:GrailsResourcesUtil:module")) {
            return;
        }
        GrMethodCall methodCall = (GrMethodCall)elementToSearch.getNavigationElement();
        GrReferenceExpression invokedExpression = (GrReferenceExpression)methodCall.getInvokedExpression();
        consumer.process((Object)new ModuleDeclarationReference(invokedExpression, elementToSearch));
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{GspFileType.GSP_FILE_TYPE, GroovyFileType.GROOVY_FILE_TYPE});
        }
        String text = elementToSearch.getName();
        queryParameters.getOptimizer().searchWord(text, searchScope, (short)12, true, (PsiElement)elementToSearch);
    }

    private static class ModuleDeclarationReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiMethod myModuleDeclaration;

        public ModuleDeclarationReference(GrReferenceExpression invokedExpression, PsiMethod moduleDeclaration) {
            super((PsiElement)invokedExpression, new TextRange(0, invokedExpression.getTextLength()), false);
            this.myModuleDeclaration = moduleDeclaration;
        }

        public PsiElement resolve() {
            return this.myModuleDeclaration;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ((GrReferenceExpression)this.getElement()).handleElementRenameSimple(newElementName);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourceReferenceSearcher$ModuleDeclarationReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

