/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspLinkNamespaceDescriptor;

public class GspLinkElementDescriptor
implements XmlElementDescriptor {
    private static final XmlAttributeDescriptor ATTR_DESCRIPTOR = new AnyXmlAttributeDescriptor("attrs");
    private final String myName;
    private final String myLocalName;
    private final PsiElement myDescriptor;
    private final Map<String, XmlAttributeDescriptor> myAttributeDescriptors;
    private final XmlAttributeDescriptor[] myAttributes;

    public GspLinkElementDescriptor(String localName, PsiElement descriptor, Map<String, Pair<PsiElement, Boolean>> params) {
        this.myName = "link:" + localName;
        this.myLocalName = localName;
        this.myDescriptor = descriptor;
        if (params.isEmpty()) {
            this.myAttributeDescriptors = Collections.singletonMap(ATTR_DESCRIPTOR.getName(), ATTR_DESCRIPTOR);
            this.myAttributes = new XmlAttributeDescriptor[]{ATTR_DESCRIPTOR};
        } else {
            this.myAttributeDescriptors = new HashMap<String, XmlAttributeDescriptor>();
            this.myAttributes = new XmlAttributeDescriptor[params.size() + 1];
            this.myAttributes[0] = ATTR_DESCRIPTOR;
            this.myAttributeDescriptors.put(ATTR_DESCRIPTOR.getName(), ATTR_DESCRIPTOR);
            int i = 1;
            for (Map.Entry<String, Pair<PsiElement, Boolean>> entry : params.entrySet()) {
                LinkAttributeDescriptor descr = new LinkAttributeDescriptor(entry.getKey(), (PsiElement)entry.getValue().first, (Boolean)entry.getValue().second);
                this.myAttributeDescriptors.put(entry.getKey(), (XmlAttributeDescriptor)descr);
                this.myAttributes[i++] = descr;
            }
        }
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return EMPTY_ARRAY;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        return null;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return this.myAttributes;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor res = this.myAttributeDescriptors.get(attributeName);
        if (res == null) {
            res = new AnyXmlAttributeDescriptor(attributeName);
        }
        return res;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), null);
    }

    public XmlNSDescriptor getNSDescriptor() {
        return GspLinkNamespaceDescriptor.INSTANCE;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return 0;
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myDescriptor;
    }

    public String getName(PsiElement context) {
        return this.myName;
    }

    public String getName() {
        return this.myLocalName;
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init is not yet implemented in " + this.getClass().getName());
    }

    public Object[] getDependences() {
        throw new UnsupportedOperationException("Method getDependences is not yet implemented in " + this.getClass().getName());
    }

    private static class LinkAttributeDescriptor
    extends BasicXmlAttributeDescriptor {
        private final String name;
        private final PsiElement element;
        private final boolean myOptional;

        public LinkAttributeDescriptor(String name, PsiElement element, boolean isOptional) {
            this.name = name;
            this.element = element;
            this.myOptional = isOptional;
        }

        public boolean isRequired() {
            return !this.myOptional;
        }

        public boolean isFixed() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public boolean isEnumerated() {
            return false;
        }

        public String[] getEnumeratedValues() {
            throw new RuntimeException();
        }

        public PsiElement getDeclaration() {
            return this.element;
        }

        public String getName() {
            return this.name;
        }

        public void init(PsiElement element) {
            throw new UnsupportedOperationException("Method init is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        public Object[] getDependences() {
            throw new UnsupportedOperationException("Method getDependences is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
        }
    }
}

