/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.parsing.gsp.chameleons;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspDirectiveFlexLexer;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.directive.GspDirectiveImpl;

public class GspDirectiveElement
extends CustomParsingType
implements GspTokenTypes,
GspElementTypes {
    public GspDirectiveElement(String debugName) {
        super(debugName, (Language)GspLanguage.INSTANCE);
    }

    @NotNull
    public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/lang/gsp/parsing/gsp/chameleons/GspDirectiveElement", "parse"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/plugins/grails/lang/gsp/parsing/gsp/chameleons/GspDirectiveElement", "parse"));
        }
        GspDirectiveImpl root = new GspDirectiveImpl();
        GspDirectiveFlexLexer lexer = new GspDirectiveFlexLexer(){

            public IElementType getTokenType() {
                IElementType type = super.getTokenType();
                if (type == XmlTokenType.XML_TAG_NAME) {
                    return XmlTokenType.XML_NAME;
                }
                return type;
            }
        };
        lexer.start(text);
        GspDirectiveElement.parseDirective((Lexer)lexer, (CompositeElement)root, table);
        if (lexer.getTokenType() != null) {
            CompositeElement errorElement = GspDirectiveElement.addErrorElement((CompositeElement)root, GrailsBundle.message("gsp.unparseable.content", new Object[0]));
            while (lexer.getTokenType() != null) {
                GspDirectiveElement.addAndAdvance(errorElement, (Lexer)lexer, table);
            }
        }
        GspDirectiveImpl gspDirectiveImpl = root;
        if (gspDirectiveImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/gsp/chameleons/GspDirectiveElement", "parse"));
        }
        return gspDirectiveImpl;
    }

    private static void parseDirective(Lexer lexer, CompositeElement treeElement, CharTable table) {
        if (lexer.getTokenType() != GDIRECT_BEGIN && lexer.getTokenType() != JDIRECT_BEGIN) {
            return;
        }
        GspDirectiveElement.addAndAdvance(treeElement, lexer, table);
        if (lexer.getTokenType() == XML_WHITE_SPACE) {
            GspDirectiveElement.addAndAdvance(treeElement, lexer, table);
        }
        if (lexer.getTokenType() != XML_NAME) {
            return;
        }
        GspDirectiveElement.addAndAdvance(treeElement, lexer, table);
        while (lexer.getTokenType() == XML_WHITE_SPACE || lexer.getTokenType() == XML_NAME) {
            if (lexer.getTokenType() == XML_WHITE_SPACE) {
                GspDirectiveElement.addAndAdvance(treeElement, lexer, table);
            }
            if (lexer.getTokenType() != XML_NAME) continue;
            CompositeElement attribute = ASTFactory.composite((IElementType)GSP_DIRECTIVE_ATTRIBUTE);
            treeElement.rawAddChildren((TreeElement)attribute);
            GspDirectiveElement.parseAttribute(lexer, attribute, table);
        }
        if (lexer.getTokenType() == GDIRECT_END || lexer.getTokenType() == JDIRECT_END) {
            GspDirectiveElement.addAndAdvance(treeElement, lexer, table);
        }
    }

    private static void parseAttribute(Lexer lexer, CompositeElement attribute, CharTable table) {
        GspDirectiveElement.addAndAdvance(attribute, lexer, table);
        if (lexer.getTokenType() == XML_WHITE_SPACE) {
            GspDirectiveElement.addAndAdvance(attribute, lexer, table);
        }
        if (lexer.getTokenType() != XML_EQ) {
            GspDirectiveElement.addErrorElement(attribute, GrailsBundle.message("expected.attribute.eq.sign", new Object[0]));
            return;
        }
        GspDirectiveElement.addAndAdvance(attribute, lexer, table);
        if (lexer.getTokenType() == XML_WHITE_SPACE) {
            GspDirectiveElement.addAndAdvance(attribute, lexer, table);
        }
        if (lexer.getTokenType() != XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            GspDirectiveElement.addErrorElement(attribute, GrailsBundle.message("attribute.value.expected", new Object[0]));
            return;
        }
        CompositeElement attributeValue = ASTFactory.composite((IElementType)GSP_DIRECTIVE_ATTRIBUTE_VALUE);
        attribute.rawAddChildren((TreeElement)attributeValue);
        GspDirectiveElement.addAndAdvance(attributeValue, lexer, table);
        if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
            GspDirectiveElement.addAndAdvance(attributeValue, lexer, table);
        }
        if (lexer.getTokenType() != XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            GspDirectiveElement.addErrorElement(attributeValue, GrailsBundle.message("quote.expected", new Object[0]));
            return;
        }
        GspDirectiveElement.addAndAdvance(attributeValue, lexer, table);
    }

    private static void addAndAdvance(CompositeElement attribute, Lexer lexer, CharTable table) {
        attribute.rawAddChildren(GspDirectiveElement.createTokenElement(lexer, table));
        lexer.advance();
    }

    private static CompositeElement addErrorElement(CompositeElement treeElement, String message) {
        CompositeElement errorElement = Factory.createErrorElement((String)message);
        treeElement.rawAddChildren((TreeElement)errorElement);
        return errorElement;
    }

    @Nullable
    private static TreeElement createTokenElement(Lexer lexer, CharTable table) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)((ILazyParseableElementType)tokenType), (CharSequence)LexerUtil.internToken((Lexer)lexer, (CharTable)table));
        }
        return ASTFactory.leaf((IElementType)tokenType, (CharSequence)LexerUtil.internToken((Lexer)lexer, (CharTable)table));
    }
}

