/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.parsing.groovy.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspFlexLexer;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;

public class GspGroovyLexer
extends Lexer
implements GspTokenTypes {
    static final TokenSet TOKENS_TO_IGNORE = TokenSet.create((IElementType[])new IElementType[]{GTAG_END_TAG_START, GTAG_START_TAG_END, GTAG_START_TAG_START, GTAG_TAG_END, JDIRECT_BEGIN, JDIRECT_END, GDIRECT_BEGIN, GDIRECT_END, GSP_WHITE_SPACE, GSP_TAG_NAME, GSP_ATTR_NAME, GSP_EQ, GSP_BAD_CHARACTER, GSP_ATTR_VALUE_START_DELIMITER, GSP_ATTR_VALUE_END_DELIMITER, GSP_ATTRIBUTE_VALUE_TOKEN, GSP_STYLE_COMMENT, JSP_STYLE_COMMENT});
    private final Lexer myGspLexer = new GspFlexLexer();
    private final GroovyLexer myGroovyLexer = new GroovyLexer();
    private Lexer myCurrentGroovyLexer = null;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/grails/lang/gsp/parsing/groovy/lexer/GspGroovyLexer", "start"));
        }
        this.myGspLexer.start(buffer, startOffset, endOffset, initialState);
        this.setUpGroovyLexer();
    }

    public int getState() {
        return this.myGspLexer.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType tokenType = this.myGspLexer.getTokenType();
        if (GROOVY_CODE.equals(tokenType)) {
            return this.myCurrentGroovyLexer.getTokenType();
        }
        return GspGroovyLexer.convertTokenType(tokenType);
    }

    private static IElementType convertTokenType(IElementType tokenType) {
        if (TOKENS_TO_IGNORE.contains(tokenType) || GSP_DIRECTIVE == tokenType || XmlTokenType.XML_WHITE_SPACE == tokenType) {
            return GspTokenTypesEx.GSP_TEMPLATE_DATA;
        }
        return tokenType;
    }

    public int getTokenStart() {
        IElementType tokenType = this.myGspLexer.getTokenType();
        if (tokenType == GROOVY_CODE) {
            return this.myCurrentGroovyLexer.getTokenStart();
        }
        return this.myGspLexer.getTokenStart();
    }

    public int getTokenEnd() {
        IElementType tokenType = this.myGspLexer.getTokenType();
        if (tokenType == GROOVY_CODE) {
            return this.myCurrentGroovyLexer.getTokenEnd();
        }
        return this.myGspLexer.getTokenEnd();
    }

    public void advance() {
        IElementType tokenType = this.myGspLexer.getTokenType();
        if (tokenType == GROOVY_CODE) {
            this.myCurrentGroovyLexer.advance();
            if (this.myCurrentGroovyLexer.getTokenType() != null) {
                return;
            }
        }
        this.myGspLexer.advance();
        this.setUpGroovyLexer();
    }

    private void setUpGroovyLexer() {
        IElementType tokenType;
        while ((tokenType = this.myGspLexer.getTokenType()) == GROOVY_CODE) {
            this.myCurrentGroovyLexer = this.myGroovyLexer;
            this.myCurrentGroovyLexer.start(this.myGspLexer.getBufferSequence(), this.myGspLexer.getTokenStart(), this.myGspLexer.getTokenEnd());
            if (this.myCurrentGroovyLexer.getTokenType() != null) {
                return;
            }
            this.myGspLexer.advance();
        }
        return;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        GspPosition gspPosition = new GspPosition(this.myCurrentGroovyLexer != null ? this.myCurrentGroovyLexer.getCurrentPosition() : null, this.myGspLexer.getCurrentPosition());
        if (gspPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/groovy/lexer/GspGroovyLexer", "getCurrentPosition"));
        }
        return gspPosition;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/grails/lang/gsp/parsing/groovy/lexer/GspGroovyLexer", "restore"));
        }
        if (position instanceof GspPosition) {
            GspPosition gspPosition = (GspPosition)position;
            this.myGspLexer.restore((LexerPosition)gspPosition);
            LexerPosition groovyPosition = gspPosition.getGroovyPosition();
            if (groovyPosition != null && this.myCurrentGroovyLexer != null && groovyPosition.getOffset() < this.myCurrentGroovyLexer.getBufferEnd()) {
                this.myCurrentGroovyLexer.restore(groovyPosition);
            } else {
                this.myCurrentGroovyLexer = null;
                this.setUpGroovyLexer();
            }
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myGspLexer.getBufferSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/groovy/lexer/GspGroovyLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myGspLexer.getBufferEnd();
    }

    private static class GspPosition
    implements LexerPosition {
        private final LexerPosition myGroovyPosition;
        private final LexerPosition myGspPosition;

        public GspPosition(LexerPosition groovyPosition, LexerPosition gspPosition) {
            this.myGroovyPosition = groovyPosition;
            this.myGspPosition = gspPosition;
        }

        public int getOffset() {
            int gspPos = this.myGspPosition != null ? this.myGspPosition.getOffset() : 0;
            int groovyPos = this.myGroovyPosition == null ? 0 : this.myGroovyPosition.getOffset();
            return Math.max(gspPos, groovyPos);
        }

        public LexerPosition getGroovyPosition() {
            return this.myGroovyPosition;
        }

        public LexerPosition getGspPosition() {
            return this.myGspPosition;
        }

        public int getState() {
            throw new UnsupportedOperationException("Method getState is not yet implemented in " + this.getClass().getName());
        }
    }
}

