/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GspTextSyntheticBlock
implements Block {
    private final Block myParentBlock;
    private Indent myIndent;
    private final List<Block> mySubBlocks;
    private final int myFromIndex;
    private final TextRange myTextRange;
    private static final Logger LOG = Logger.getInstance(GspTextSyntheticBlock.class);

    public GspTextSyntheticBlock(Block parentBlock, int fromIndex, Indent indent, List<Block> subBlocks) {
        this.myParentBlock = parentBlock;
        this.myIndent = indent;
        this.mySubBlocks = subBlocks;
        this.myFromIndex = fromIndex;
        this.myTextRange = new TextRange(subBlocks.get(0).getTextRange().getStartOffset(), subBlocks.get(subBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getSubBlocks"));
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex > 0 && this.mySubBlocks.get(newChildIndex - 1) instanceof GspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (newChildIndex == 0 && this.mySubBlocks.get(0) instanceof GspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = this.myParentBlock.getChildAttributes(this.myFromIndex + newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myParentBlock.isIncomplete();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspTextSyntheticBlock", "getSpacing"));
        }
        Block first = child1 instanceof GspTextSyntheticBlock ? ((GspTextSyntheticBlock)child1).myParentBlock : child1;
        Block second = child2 instanceof GspTextSyntheticBlock ? ((GspTextSyntheticBlock)child2).myParentBlock : child2;
        return this.myParentBlock.getSpacing(first, second);
    }

    public void setIndent(Indent parentIndent) {
        this.myIndent = parentIndent;
    }

    public boolean isLeaf() {
        return false;
    }
}

