/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForeignLanguageBlock
extends AbstractXmlBlock {
    private final Block myOriginal;
    private final Indent myIndent;

    public ForeignLanguageBlock(ASTNode node, XmlFormattingPolicy policy, Block original, Indent indent) {
        super(node, original.getWrap(), original.getAlignment(), policy);
        this.myOriginal = original;
        this.myIndent = indent;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return true;
    }

    protected List<Block> buildChildren() {
        return this.myOriginal.getSubBlocks();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/ForeignLanguageBlock", "getSpacing"));
        }
        return this.myOriginal.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/ForeignLanguageBlock", "getChildAttributes"));
        }
        return childAttributes;
    }
}

