/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.impl.GspGroovyFileImpl;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class GspFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static Set<Language> LANGUAGES = new LinkedHashSet<Language>(Arrays.asList(new Language[]{GspLanguage.INSTANCE, GroovyLanguage.INSTANCE, StdLanguages.HTML}));

    public GspFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        GspLanguage gspLanguage = GspLanguage.INSTANCE;
        if (gspLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider", "getBaseLanguage"));
        }
        return gspLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = LANGUAGES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile copy) {
        return new GspFileViewProvider(this.getManager(), copy, false);
    }

    protected PsiFile createFile(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider", "createFile"));
        }
        if (language == this.getBaseLanguage()) {
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
            assert (parserDefinition != null);
            return parserDefinition.createFile((FileViewProvider)this);
        }
        if (language == GroovyLanguage.INSTANCE) {
            return new GspGroovyFileImpl((FileViewProvider)this);
        }
        if (language == StdLanguages.HTML) {
            return new GspHtmlFileImpl((FileViewProvider)this);
        }
        return super.createFile(language);
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider", "findElementAt"));
        }
        PsiElement ret = null;
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement elementInBaseRoot = this.findElementByLanguage(offset, lang, ret, this.getBaseLanguage());
        if (GspFileViewProvider.isMeaningfulElement(elementInBaseRoot)) {
            return elementInBaseRoot;
        }
        for (Language language : LANGUAGES) {
            PsiElement found = this.findElementByLanguage(offset, lang, ret, language);
            if (ret != null && this.getPsi(language) == mainRoot) continue;
            ret = found;
        }
        return ret;
    }

    private PsiElement findElementByLanguage(int offset, Class<? extends Language> lang, PsiElement ret, Language language) {
        if (!ReflectionUtil.isAssignable(lang, language.getClass())) {
            return ret;
        }
        if (lang.equals(Language.class) && !LANGUAGES.contains(language)) {
            return ret;
        }
        PsiFile psiRoot = this.getPsi(language);
        PsiElement psiElement = GspFileViewProvider.findElementAt((PsiElement)psiRoot, (int)offset);
        if (psiElement == null || psiElement instanceof OuterLanguageElement && !GspFileViewProvider.isMeaningfulElement(psiElement)) {
            return ret;
        }
        if (ret == null) {
            ret = psiElement;
        }
        return ret;
    }

    private static boolean isMeaningfulElement(PsiElement elementInBaseRoot) {
        return JavaScriptIntegrationUtil.isJavaScriptInjection(elementInBaseRoot);
    }
}

