/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.i18n.GrailsI18nGroovyQuickFixHandler;
import org.jetbrains.plugins.grails.i18n.GrailsI18nQuickFixHandler;
import org.jetbrains.plugins.grails.i18n.GrailsI18nizeProvider;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspExpressionTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GspI18nIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Extract selected text to message.properties" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GspI18nIntention", "getText"));
        }
        return "Extract selected text to message.properties";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GspI18nIntention", "getFamilyName"));
        }
        return string;
    }

    private static boolean isGroovyStringLiteral(Editor editor, PsiFile file) {
        if (file instanceof GspFile) {
            file = ((GspFile)file).getGroovyLanguageRoot();
        }
        return file instanceof GroovyFileBase && (file.getViewProvider() instanceof GspFileViewProvider || GrailsI18nizeProvider.isApplicableGroovyFile((GroovyFileBase)file)) && GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, file) != null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/i18n/GspI18nIntention", "isAvailable"));
        }
        if (GspI18nIntention.isGroovyStringLiteral(editor, file)) {
            return true;
        }
        if (!(file instanceof GspFile) && !(file instanceof GspHtmlFileImpl)) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return false;
        }
        TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)file);
        if (selectedRange == null) {
            return false;
        }
        PsiElement e = file.getViewProvider().findElementAt(selectedRange.getStartOffset(), StdLanguages.HTML);
        while (true) {
            if (e == null) {
                return false;
            }
            if (e instanceof OuterLanguageElement) {
                PsiElement gspElement = file.getViewProvider().findElementAt(e.getTextOffset(), (Language)GspLanguage.INSTANCE);
                if (gspElement == null) {
                    return false;
                }
                PsiElement exprTag = gspElement.getParent();
                if (!(exprTag instanceof GspExpressionTag)) {
                    return false;
                }
                TextRange exprTagTextRange = exprTag.getTextRange();
                if (!selectedRange.contains(exprTagTextRange)) {
                    return false;
                }
                if (selectedRange.getEndOffset() == exprTagTextRange.getEndOffset()) break;
                e = file.getViewProvider().findElementAt(exprTagTextRange.getEndOffset(), StdLanguages.HTML);
                continue;
            }
            if (e.getTextOffset() + e.getTextLength() >= selectedRange.getEndOffset()) break;
            e = PsiTreeUtil.nextLeaf((PsiElement)e);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/i18n/GspI18nIntention", "invoke"));
        }
        if (GspI18nIntention.isGroovyStringLiteral(editor, file)) {
            I18nizeAction.doI18nSelectedString((Project)project, (Editor)editor, (PsiFile)file, (I18nQuickFixHandler)GrailsI18nGroovyQuickFixHandler.INSTANCE);
            return;
        }
        if (file instanceof GspFile) {
            file = file.getViewProvider().getPsi(StdLanguages.HTML);
        }
        assert (file instanceof GspHtmlFileImpl);
        PsiFile gspFile = file.getViewProvider().getPsi((Language)GspLanguage.INSTANCE);
        assert (gspFile != null);
        I18nizeAction.doI18nSelectedString((Project)project, (Editor)editor, (PsiFile)gspFile, (I18nQuickFixHandler)GrailsI18nQuickFixHandler.INSTANCE);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

