/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GrGspExprInjection;

public class GrailsGroovyInjectionSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return e instanceof GrGspExprInjection;
    }

    public List<TextRange> select(PsiElement element, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement prev = element.getPrevSibling();
        PsiElement next = element.getNextSibling();
        if (PsiImplUtil.isLeafElementOfType((PsiElement)prev, (IElementType)GspTokenTypes.GEXPR_BEGIN) && PsiImplUtil.isLeafElementOfType((PsiElement)next, (IElementType)GspTokenTypes.GEXPR_END) || PsiImplUtil.isLeafElementOfType((PsiElement)prev, (IElementType)GspTokenTypes.JEXPR_BEGIN) && PsiImplUtil.isLeafElementOfType((PsiElement)next, (IElementType)GspTokenTypes.JEXPR_END)) {
            assert (next != null);
            assert (prev != null);
            return Collections.singletonList(new TextRange(prev.getTextOffset(), next.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }
}

