/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GrailsDependencySelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        PsiElement parent = e.getParent();
        if (!(parent instanceof GrLiteralImpl || parent instanceof GrStringImpl && e instanceof GrStringContent)) {
            return false;
        }
        PsiElement argumentList = parent.getParent();
        if (!(argumentList instanceof GrArgumentList)) {
            return false;
        }
        PsiElement methodCall = argumentList.getParent();
        if (!(methodCall instanceof GrMethodCall)) {
            return false;
        }
        GrClosableBlock dependencyClosure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)methodCall, GrClosableBlock.class);
        if (dependencyClosure == null) {
            return false;
        }
        PsiElement dependencyMethodCall = dependencyClosure.getParent();
        if (dependencyMethodCall instanceof GrArgumentList) {
            dependencyMethodCall = dependencyMethodCall.getParent();
        }
        if (!(dependencyMethodCall instanceof GrMethodCall)) {
            return false;
        }
        String methodName = PsiUtil.getMethodName((GrMethodCall)((GrMethodCall)dependencyMethodCall));
        if (!"plugins".equals(methodName) && !"dependencies".equals(methodName)) {
            return false;
        }
        PsiElement depResolutionClosure = dependencyMethodCall.getParent();
        if (!(depResolutionClosure instanceof GrClosableBlock)) {
            return false;
        }
        PsiElement eAssignmentExpression = depResolutionClosure.getParent();
        if (!(eAssignmentExpression instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)eAssignmentExpression;
        if (assignmentExpression.getRValue() != depResolutionClosure || !"grails.project.dependency.resolution".equals(assignmentExpression.getLValue().getText())) {
            return false;
        }
        return "BuildConfig.groovy".equals(assignmentExpression.getContainingFile().getName());
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        int end;
        int begin;
        TextRange range;
        if (e.getParent() instanceof GrLiteralImpl) {
            String text = e.getText();
            range = GroovyStringLiteralManipulator.getLiteralRange((String)text).shiftRight(e.getTextRange().getStartOffset());
        } else {
            range = e.getTextRange();
        }
        for (begin = cursorOffset; begin > range.getStartOffset() && editorText.charAt(begin - 1) != ':'; --begin) {
        }
        for (end = cursorOffset; end < range.getEndOffset() && editorText.charAt(end) != ':'; ++end) {
        }
        return Collections.singletonList(new TextRange(begin, end));
    }
}

