/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"DECORATED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "DECORATED_ARTEFACT_TYPES", "", "Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "getDECORATED_ARTEFACT_TYPES", "()[Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "[Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "checkApplicable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "decorate", "", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "decorateLater", "doDecorate", "groovy-mvc"})
public final class GrailsEditorDecoratorKt {
    @NotNull
    private static final GrailsArtifact[] DECORATED_ARTEFACT_TYPES;
    private static final Key<Boolean> DECORATED;

    @NotNull
    public static final GrailsArtifact[] getDECORATED_ARTEFACT_TYPES() {
        return DECORATED_ARTEFACT_TYPES;
    }

    public static final void decorate(@NotNull FileEditorManager manager, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!GrailsEditorDecoratorKt.checkApplicable(file)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(manager, file){
            final /* synthetic */ FileEditorManager $manager;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                Project project = this.$manager.getProject();
                FileType fileType = this.$file.getFileType();
                if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
                    if (GrailsUtils.isInGrailsTests(this.$file, project) || Intrinsics.areEqual((Object)this.$file.getExtension(), (Object)"gson")) {
                        GrailsEditorDecoratorKt.access$decorateLater(this.$manager, this.$file);
                    } else {
                        GrTypeDefinition classDefinition = GroovyUtils.getPublicClass((Project)project, (VirtualFile)this.$file);
                        GrailsArtifact artifact = GrailsArtifact.getType((PsiClass)classDefinition);
                        if (ArraysKt.contains((Object[])((Object[])GrailsEditorDecoratorKt.getDECORATED_ARTEFACT_TYPES()), (Object)((Object)artifact))) {
                            GrailsEditorDecoratorKt.access$decorateLater(this.$manager, this.$file);
                        }
                    }
                } else {
                    String controllerName = GrailsUtils.getControllerNameByGsp(this.$file);
                    if (controllerName != null && Intrinsics.areEqual((Object)controllerName, (Object)"layouts") ^ true && StringUtil.isJavaIdentifier((String)controllerName)) {
                        GrailsEditorDecoratorKt.access$decorateLater(this.$manager, this.$file);
                    }
                }
            }
            {
                this.$manager = fileEditorManager;
                this.$file = virtualFile;
            }
        });
    }

    private static final boolean checkApplicable(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == GroovyFileType.GROOVY_FILE_TYPE || fileType == GspFileType.GSP_FILE_TYPE || Intrinsics.areEqual((Object)"jsp", (Object)file.getExtension());
    }

    private static final void decorateLater(FileEditorManager manager, VirtualFile file) {
        ApplicationManager.getApplication().invokeLater(new Runnable(manager, file){
            final /* synthetic */ FileEditorManager $manager;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                GrailsEditorDecoratorKt.access$doDecorate(this.$manager, this.$file);
            }
            {
                this.$manager = fileEditorManager;
                this.$file = virtualFile;
            }
        }, manager.getProject().getDisposed());
    }

    private static final void doDecorate(FileEditorManager manager, VirtualFile file) {
        FileEditor[] fileEditorArray = manager.getEditors(file);
        for (int i = 0; i < fileEditorArray.length; ++i) {
            FileEditor editor = fileEditorArray[i];
            if (!(editor instanceof TextEditor) || editor.getUserData(DECORATED) != null) continue;
            editor.putUserData(DECORATED, (Object)true);
            AnAction anAction = ActionManager.getInstance().getAction("grails.toolbar");
            if (anAction == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            }
            ActionGroup group = (ActionGroup)anAction;
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true);
            toolbar.setTargetComponent(((TextEditor)editor).getComponent());
            manager.addTopComponent(editor, toolbar.getComponent());
        }
    }

    static {
        GrailsArtifact[] elements$iv = new GrailsArtifact[]{GrailsArtifact.DOMAIN, GrailsArtifact.CONTROLLER, GrailsArtifact.SERVICE};
        DECORATED_ARTEFACT_TYPES = (GrailsArtifact[])((Object[])elements$iv);
        DECORATED = Key.create((String)"grails.decorator.decorated");
    }

    @NotNull
    public static final /* synthetic */ Key access$getDECORATED$p() {
        return DECORATED;
    }

    public static final /* synthetic */ void access$decorateLater(@NotNull FileEditorManager manager, @NotNull VirtualFile file) {
        GrailsEditorDecoratorKt.decorateLater(manager, file);
    }

    public static final /* synthetic */ void access$doDecorate(@NotNull FileEditorManager manager, @NotNull VirtualFile file) {
        GrailsEditorDecoratorKt.doDecorate(manager, file);
    }
}

