/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GrailsSettings {
    @Nullable
    public Integer buildConfigCrc;
    public int pluginDependenciesCrc;
    public int pluginsCrc;
    public String fixedGrailsVersion;
    public Map<String, String> properties = new THashMap();
    public Map<String, String> customPluginLocations = new THashMap();

    public boolean isBuildConfigOutdated(@Nullable String text) {
        return this.buildConfigCrc == null || this.buildConfigCrc != GrailsSettings.getScriptCrc(text);
    }

    public void updateBuildConfig(@Nullable String text) {
        this.buildConfigCrc = text == null ? 0 : GrailsSettings.getScriptCrc(text);
    }

    public boolean hasParsedBuildConfig() {
        return this.buildConfigCrc != null;
    }

    public static int getScriptCrc(@Nullable String text) {
        IElementType tokenType;
        if (text == null) {
            return 0;
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)text);
        CRC32 crc = new CRC32();
        while ((tokenType = lexer.getTokenType()) != null) {
            if (TokenSets.WHITE_SPACES_SET.contains(tokenType)) {
                crc.update(1);
            } else if (TokenSets.COMMENT_SET.contains(tokenType)) {
                crc.update(2);
            } else {
                int end = lexer.getTokenEnd();
                for (int start = lexer.getTokenStart(); start < end; ++start) {
                    char a = text.charAt(start);
                    crc.update(a);
                    crc.update(a >>> 8);
                }
            }
            lexer.advance();
        }
        return (int)crc.getValue();
    }
}

