/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.commands;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.commands.GrailsCommandProvider;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.groovy.mvc.util.MvcTargetDialogCompletionUtils;

public class GrailsCommandCompletionUtil {
    private static final String[] SYSTEM_PROPERTIES = new String[]{"grails.home", "ivy.default.ivy.user.dir", "ivy.default.conf.dir", "ivy.local.default.root", "ivy.local.default.ivy.pattern", "ivy.local.default.artifact.pattern", "ivy.shared.default.root", "ivy.shared.default.ivy.pattern", "ivy.shared.default.artifact.pattern", "ivy.ivyrep.default.ivy.root", "ivy.ivyrep.default.ivy.pattern", "ivy.ivyrep.default.artifact.root", "ivy.ivyrep.default.artifact.pattern", "grails.servlet.version", "base.dir", "grails.work.dir", "grails.project.work.dir", "grails.project.war.exploded.dir", "grails.project.plugins.dir", "grails.global.plugins.dir", "grails.project.resource.dir", "grails.project.source.dir", "grails.project.web.xml", "grails.project.class.dir", "grails.project.plugin.class.dir", "grails.project.plugin.build.class.dir", "grails.project.plugin.provided.class.dir", "grails.project.test.class.dir", "grails.project.test.reports.dir", "grails.project.docs.output.dir", "grails.project.test.source.dir", "grails.project.target.dir", "grails.project.war.file", "grails.project.war.file", "grails.project.war.osgi.headers", "grails.build.listeners", "grails.project.compile.verbose", "grails.testing.functional.baseUrl", "grails.compile.artefacts.closures.convert", "grails.project.source.level", "grails.project.target.level"};
    public static final NotNullLazyValue<List<LookupElement>> SYSTEM_PROPERTIES_VARIANTS = new NotNullLazyValue<List<LookupElement>>(){

        @NotNull
        protected List<LookupElement> compute() {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (String property : SYSTEM_PROPERTIES) {
                result2.add(TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)("-D" + property)), (TailType)MvcTargetDialogCompletionUtils.MyTailTypeEQ.INSTANCE));
            }
            List<LookupElement> list = Collections.unmodifiableList(result2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil$1", "compute"));
            }
            return list;
        }
    };

    public static Collection<LookupElement> collectVariants(@Nullable GrailsApplication application, @NotNull String text, int offset, @NotNull String prefix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "collectVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "collectVariants"));
        }
        if (prefix.startsWith("-D")) {
            return (Collection)SYSTEM_PROPERTIES_VARIANTS.getValue();
        }
        if (application == null) {
            return Collections.emptyList();
        }
        if (text.substring(0, offset).matches("\\s*(grails\\s*)?(?:(:?-D\\S+|dev|prod|test)\\s+)*\\S*")) {
            return GrailsCommandCompletionUtil.getAllCommandNames(application).stream().map(c -> TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)c), (TailType)TailType.SPACE)).collect(Collectors.toList());
        }
        return MvcTargetDialogCompletionUtils.completeClassesAndPackages((String)prefix, (GlobalSearchScope)application.getScope(false, false));
    }

    @NotNull
    public static Collection<String> getAllCommandNames(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "getAllCommandNames"));
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)application.getProject()).getCachedValue((UserDataHolder)application, () -> {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "lambda$getAllCommandNames$1"));
            }
            return CachedValueProvider.Result.create(GrailsCommandCompletionUtil.doGetAllCommandNames(application), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "getAllCommandNames"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> doGetAllCommandNames(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "doGetAllCommandNames"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (GrailsCommandProvider provider : (GrailsCommandProvider[])GrailsCommandProvider.EP_NAME.getExtensions()) {
            provider.addCommands(application, result2);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/commands/GrailsCommandCompletionUtil", "doGetAllCommandNames"));
        }
        return arrayList;
    }
}

