/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.addins.js;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspExpressionTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspScriptletTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttribute;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;

public class GrailsJavaScriptInjector
implements MultiHostInjector {
    private static Pattern ATTRIBUTE_PATTERN;

    public static Pattern getAttributePattern() {
        if (ATTRIBUTE_PATTERN == null) {
            ATTRIBUTE_PATTERN = Pattern.compile("on([A-Z][a-z]+|_\\d+|blur|click|change|dblclick|focus|keydown|keypress|keyup|mousedown|mousemove|mouseout|mouseover|mouseup|submit)");
        }
        return ATTRIBUTE_PATTERN;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar originalRegistrar, @NotNull PsiElement eTag) {
        if (originalRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalRegistrar", "org/jetbrains/plugins/grails/addins/js/GrailsJavaScriptInjector", "getLanguagesToInject"));
        }
        if (eTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eTag", "org/jetbrains/plugins/grails/addins/js/GrailsJavaScriptInjector", "getLanguagesToInject"));
        }
        GspGrailsTag tag = (GspGrailsTag)eTag;
        String tagName = tag.getName();
        if (JavaScriptIntegrationUtil.isJsInjectionTag(tagName)) {
            MultiHostRegistrar currentRegistrar = null;
            PsiElement child = tag.getFirstChild();
            while (child != null) {
                PsiElement nextSibling = child.getNextSibling();
                if (JavaScriptIntegrationUtil.isInjectAvailable(child)) {
                    if (currentRegistrar == null) {
                        currentRegistrar = originalRegistrar.startInjecting((Language)JavascriptLanguage.INSTANCE);
                    }
                    String suffix = nextSibling instanceof GspExpressionTag || nextSibling instanceof GspScriptletTag ? " fpwmx8th2p8v2 " : null;
                    currentRegistrar = currentRegistrar.addPlace(null, suffix, (PsiLanguageInjectionHost)child, new TextRange(0, child.getTextLength()));
                }
                child = nextSibling;
            }
            if (currentRegistrar != null) {
                currentRegistrar.doneInjecting();
            }
        } else {
            boolean hasBeforeAndAfter = tagName.equals("g:formRemote") || tagName.equals("g:remoteField") || tagName.equals("g:remoteFunction") || tagName.equals("g:remoteLink") || tagName.equals("g:submitToRemote");
            for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                int length;
                XmlAttributeValue value;
                if (!(child instanceof GspAttribute)) continue;
                GspAttribute attribute = (GspAttribute)child;
                String name = attribute.getName();
                if (!GrailsJavaScriptInjector.getAttributePattern().matcher(name).matches() && (!hasBeforeAndAfter || !name.equals("before") && !name.equals("after")) || (value = attribute.getValueElement()) == null || (length = value.getTextLength()) < 2 || length != 2 && !GrailsPsiUtil.isSimpleAttribute(value)) continue;
                MultiHostRegistrar currentRegistrar = originalRegistrar.startInjecting((Language)JavascriptLanguage.INSTANCE);
                currentRegistrar = currentRegistrar.addPlace(null, null, (PsiLanguageInjectionHost)value, new TextRange(1, length - 1));
                currentRegistrar.doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<GspGrailsTag>> list = Collections.singletonList(GspGrailsTag.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/addins/js/GrailsJavaScriptInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

