/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.view;

import com.intellij.javaee.toolwindow.view.JavaeeViewFrameworkProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.websocket.WebSocketProjectComponent;
import com.intellij.websocket.jam.WebSocketClientEndpoint;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import com.intellij.websocket.view.WebSocketViewSettings;
import com.intellij.websocket.view.WebsocketFinderRecursivePanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class WebSocketViewFrameworkProvider
extends JavaeeViewFrameworkProvider {
    public boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "isAvailable"));
        }
        if (WebSocketCommonUtils.isWebSocketInstalled(module)) {
            return WebSocketJamModel.getModel(module.getProject()).getEndpoints(module).size() > 0;
        }
        return false;
    }

    @NotNull
    public JComponent createModuleView(@NotNull FinderRecursivePanel parent, @NotNull Module module, @NotNull DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createModuleView"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createModuleView"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createModuleView"));
        }
        WebsocketFinderRecursivePanel websocketFinderRecursivePanel = new WebsocketFinderRecursivePanel(parent, module, actions);
        if (websocketFinderRecursivePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createModuleView"));
        }
        return websocketFinderRecursivePanel;
    }

    @NotNull
    public JComponent createProjectView(@NotNull FinderRecursivePanel parent, @NotNull Project project, @NotNull DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createProjectView"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createProjectView"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createProjectView"));
        }
        WebsocketFinderRecursivePanel websocketFinderRecursivePanel = new WebsocketFinderRecursivePanel(parent, null, actions);
        if (websocketFinderRecursivePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "createProjectView"));
        }
        return websocketFinderRecursivePanel;
    }

    @NotNull
    public static List<WebSocketEndpoint> getFilteredEndpoints(@NotNull List<WebSocketEndpoint> endpoints, @NotNull Project project) {
        if (endpoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endpoints", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "getFilteredEndpoints"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "getFilteredEndpoints"));
        }
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(project).getState();
        if (viewSettings == null) {
            List<WebSocketEndpoint> list = endpoints;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "getFilteredEndpoints"));
            }
            return list;
        }
        ArrayList<WebSocketEndpoint> filtered = new ArrayList<WebSocketEndpoint>();
        for (WebSocketEndpoint endpoint : endpoints) {
            if ((!(endpoint instanceof WebSocketServerEndpoint) || !viewSettings.server) && (!(endpoint instanceof WebSocketClientEndpoint) || !viewSettings.client)) continue;
            filtered.add(endpoint);
        }
        ArrayList<WebSocketEndpoint> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/view/WebSocketViewFrameworkProvider", "getFilteredEndpoints"));
        }
        return arrayList;
    }
}

