/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.websocket.jam.WebSocketClientEndpoint;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebSocketJamModel {
    private final Project myProject;

    public static WebSocketJamModel getModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/jam/WebSocketJamModel", "getModel"));
        }
        return (WebSocketJamModel)ServiceManager.getService((Project)project, WebSocketJamModel.class);
    }

    public WebSocketJamModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/jam/WebSocketJamModel", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<WebSocketEndpoint> getEndpoints(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/jam/WebSocketJamModel", "getEndpoints"));
        }
        List<WebSocketEndpoint> list = this.getEndpoints(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketJamModel", "getEndpoints"));
        }
        return list;
    }

    @NotNull
    public List<WebSocketEndpoint> getEndpoints(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/jam/WebSocketJamModel", "getEndpoints"));
        }
        List<WebSocketEndpoint> list = this.getEndpoints(ProjectScope.getAllScope((Project)project));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketJamModel", "getEndpoints"));
        }
        return list;
    }

    private List<WebSocketEndpoint> getEndpoints(GlobalSearchScope scope) {
        ArrayList<WebSocketEndpoint> endpoints = new ArrayList<WebSocketEndpoint>();
        endpoints.addAll(this.getServerEndpoints(scope));
        endpoints.addAll(this.getClientEndpoints(scope));
        return endpoints;
    }

    @NotNull
    public List<WebSocketServerEndpoint> getServerEndpoints(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/jam/WebSocketJamModel", "getServerEndpoints"));
        }
        List<WebSocketServerEndpoint> list = this.getServerEndpoints(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketJamModel", "getServerEndpoints"));
        }
        return list;
    }

    @NotNull
    public List<WebSocketServerEndpoint> getServerEndpoints(GlobalSearchScope scope) {
        JamService service = JamService.getJamService((Project)this.myProject);
        List list = service.getJamClassElements(WebSocketServerEndpoint.META, "javax.websocket.server.ServerEndpoint", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketJamModel", "getServerEndpoints"));
        }
        return list;
    }

    @NotNull
    public List<WebSocketClientEndpoint> getClientEndpoints(GlobalSearchScope scope) {
        JamService service = JamService.getJamService((Project)this.myProject);
        List list = service.getJamClassElements(WebSocketClientEndpoint.META, "javax.websocket.ClientEndpoint", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketJamModel", "getClientEndpoints"));
        }
        return list;
    }
}

