/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.semantic.SemKey;
import com.intellij.util.containers.hash.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class WebSocketEndpoint
implements JamElement {
    public static final SemKey<WebSocketEndpoint> WEB_SOCKET_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("WebSocketEndpoint", new SemKey[0]);
    private static final JamStringAttributeMeta.Single<String> VALUE_META = JamAttributeMeta.singleString((String)"value");
    private static final JamClassAttributeMeta.Collection DECODERS_META = JamAttributeMeta.classCollection((String)"decoders");
    private static final JamClassAttributeMeta.Collection ENCODERS_META = JamAttributeMeta.classCollection((String)"encoders");

    @NotNull
    protected JamStringAttributeElement<String> getValueStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)this.getJamAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), VALUE_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketEndpoint", "getValueStringAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    public abstract JamAnnotationMeta getJamAnnotationMeta();

    @JamPsiConnector
    @NotNull
    public abstract PsiClass getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    public PsiNamedElement getIdentifyingPsiElement() {
        return (PsiNamedElement)PomService.convertToPsi((Project)this.getPsiElement().getProject(), (PomTarget)this.getPsiTarget());
    }

    public PsiTarget getPsiTarget() {
        return new JamPomTarget((JamElement)this, this.getValueStringAttributeElement());
    }

    @NotNull
    public String getPath() {
        String nameValue = this.getValueStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? "" : nameValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/jam/WebSocketEndpoint", "getPath"));
        }
        return string;
    }

    public Set<PsiClass> getDecoders() {
        return this.getPsiClasses(DECODERS_META);
    }

    public Set<PsiClass> getEncoders() {
        return this.getPsiClasses(ENCODERS_META);
    }

    public Set<PsiClass> getPsiClasses(JamClassAttributeMeta.Collection attrMeta) {
        HashSet psiClasses = new HashSet();
        List decodesClasses = (List)this.getJamAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), (JamAttributeMeta)attrMeta);
        for (JamClassAttributeElement bpc : decodesClasses) {
            PsiClass psiClass = bpc.getValue();
            if (psiClass == null) continue;
            psiClasses.add(psiClass);
        }
        return psiClasses;
    }
}

