/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import org.jetbrains.annotations.Nullable;

public class MemSizeConverter
extends Converter<Long> {
    public Long fromString(@Nullable String s, ConvertContext context) {
        int multiplier;
        if (s == null || s.length() == 0) {
            return null;
        }
        switch (s.charAt(s.length() - 1)) {
            case 'K': {
                multiplier = 1000;
                break;
            }
            case 'M': {
                multiplier = 1000000;
                break;
            }
            case 'G': {
                multiplier = 1000000000;
                break;
            }
            default: {
                multiplier = 1;
            }
        }
        try {
            if (multiplier == 1) {
                return Long.decode(s);
            }
            return Long.decode(s.substring(0, s.length() - 1)) * (long)multiplier;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString(Long aLong, ConvertContext context) {
        return aLong == null ? null : aLong.toString();
    }
}

