/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.StreamProviderKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JE\u0010\u0018\u001a\u00020\u00192\u001c\u0010\u001a\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u001b2\u001a\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001e\"\u0006\u0012\u0002\b\u00030\u001c\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u000e\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rJ\u0018\u0010%\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020!2\u0006\u0010$\u001a\u00020\rJ\u0018\u0010)\u001a\u00020!2\u0006\u0010$\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0016JL\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0/H\u0016J\u001a\u00101\u001a\u0004\u0018\u0001002\u0006\u0010$\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0016J(\u00102\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u00a8\u00067"}, d2={"Lcom/intellij/cloudConfig/ApplicableStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "configDir", "Ljava/io/File;", "myManager", "Lcom/intellij/cloudConfig/CloudConfigManager;", "(Ljava/io/File;Lcom/intellij/cloudConfig/CloudConfigManager;)V", "myConfigDir", "Ljava/nio/file/Path;", "getMyConfigDir", "()Ljava/nio/file/Path;", "myFileStorages", "Ljava/util/HashSet;", "", "getMyFileStorages", "()Ljava/util/HashSet;", "getMyManager", "()Lcom/intellij/cloudConfig/CloudConfigManager;", "myOSNames", "Ljava/util/HashMap;", "getMyOSNames", "()Ljava/util/HashMap;", "mySchemeStorages", "getMySchemeStorages", "addConfigs", "", "f", "Lkotlin/Function2;", "Ljava/lang/Class;", "storageClasses", "", "(Lkotlin/jvm/functions/Function2;[Ljava/lang/Class;)V", "checkFile", "", "file", "convertName", "fileSpec", "delete", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "findStorage", "isApplicable", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "write", "content", "", "size", "", "cloud-config"})
public final class ApplicableStreamProvider
implements StreamProvider {
    @NotNull
    private final Path myConfigDir;
    @NotNull
    private final HashSet<String> myFileStorages;
    @NotNull
    private final HashSet<String> mySchemeStorages;
    @NotNull
    private final HashMap<String, String> myOSNames;
    @NotNull
    private final CloudConfigManager myManager;

    @NotNull
    public final Path getMyConfigDir() {
        return this.myConfigDir;
    }

    @NotNull
    public final HashSet<String> getMyFileStorages() {
        return this.myFileStorages;
    }

    @NotNull
    public final HashSet<String> getMySchemeStorages() {
        return this.mySchemeStorages;
    }

    @NotNull
    public final HashMap<String, String> getMyOSNames() {
        return this.myOSNames;
    }

    public final void addConfigs(@NotNull Function2<? super Class<?>, ? super String, Unit> f, Class<?> ... storageClasses) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Intrinsics.checkParameterIsNotNull(storageClasses, (String)"storageClasses");
        for (int i = 0; i < storageClasses.length; ++i) {
            State spec;
            Class<?> storageClass = storageClasses[i];
            if (StoreUtil.getStateSpec(storageClass) == null) {
                Intrinsics.throwNpe();
            }
            State state = spec;
            Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"spec");
            String name = StreamProviderKt.getFileConfig(state);
            this.myFileStorages.add(name);
            f.invoke(storageClass, (Object)name);
            CharSequence charSequence = spec.additionalExportFile();
            if (!(charSequence.length() > 0)) continue;
            this.mySchemeStorages.add(spec.additionalExportFile());
            f.invoke(storageClass, (Object)spec.additionalExportFile());
        }
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        int index = StringsKt.indexOf$default((CharSequence)fileSpec, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return this.findStorage(fileSpec);
        }
        String string = fileSpec;
        int n = 0;
        ApplicableStreamProvider applicableStreamProvider = this;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        return applicableStreamProvider.findStorage(string4);
    }

    public final boolean findStorage(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return this.myFileStorages.contains(fileSpec) || this.mySchemeStorages.contains(fileSpec);
    }

    @NotNull
    public final String convertName(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        int index = StringsKt.indexOf$default((CharSequence)fileSpec, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string = this.myOSNames.get(fileSpec);
            if (string == null) {
                return fileSpec;
            }
            return string;
        }
        String string = fileSpec;
        int n = 0;
        Serializable serializable = this.myOSNames;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        String firstName = ((HashMap)serializable).get(string4);
        if (firstName != null) {
            string = fileSpec;
            n = index + 1;
            serializable = new StringBuilder().append(firstName).append("/");
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string4 = string6;
            return ((StringBuilder)serializable).append(string4).toString();
        }
        return fileSpec;
    }

    @Nullable
    public InputStream read(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Path path2 = path = this.myConfigDir.resolve(this.convertName(fileSpec));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        return this.checkFile(path2) ? PathKt.inputStream((Path)path) : (InputStream)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Path path2 = this.myConfigDir.resolve(this.convertName(path));
        Function1 function1 = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        try {
            void filter$iv;
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter)new PathKt.sam.Filter.i.4e075d77((Function1)filter$iv));
            boolean bl = false;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    Path file;
                    Path path3 = file = (Path)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
                    if (!this.checkFile(path3)) continue;
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    boolean bl3 = false;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        bl2 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it2, (Object)false);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                        try {
                            Closeable closeable3 = closeable2;
                            if (closeable3 != null) {
                                closeable3.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    finally {
                        if (!bl3) {
                            Closeable closeable4 = closeable2;
                            if (closeable4 != null) {
                                closeable4.close();
                            }
                        }
                    }
                    if (bl2) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable5 = closeable;
                    if (closeable5 != null) {
                        closeable5.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable6 = closeable;
                    if (closeable6 != null) {
                        closeable6.close();
                    }
                }
            }
        }
        catch (NoSuchFileException ignored$iv) {
        }
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String fileName = this.convertName(fileSpec);
        Path file = this.myConfigDir.resolve(fileName);
        int n = 0;
        String newContent = new String(content, n, size, Charsets.UTF_8);
        Path path = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
        if (this.checkFile(path) && Intrinsics.areEqual((Object)PathKt.readText((Path)file), (Object)newContent)) {
            return;
        }
        PathKt.write((Path)file, (byte[])content, (int)0, (int)size);
        this.myManager.editConfigFile(fileName, newContent);
    }

    public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String fileName = this.convertName(fileSpec);
        PathKt.delete((Path)this.myConfigDir.resolve(fileName));
        this.myManager.editConfigFile(fileName, null);
    }

    private final boolean checkFile(Path file) {
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)file);
        return attributes != null && !attributes.isDirectory() && attributes.size() > 0L && !PathKt.isHidden((Path)file);
    }

    @NotNull
    public final CloudConfigManager getMyManager() {
        return this.myManager;
    }

    public ApplicableStreamProvider(@NotNull File configDir, @NotNull CloudConfigManager myManager) {
        Intrinsics.checkParameterIsNotNull((Object)configDir, (String)"configDir");
        Intrinsics.checkParameterIsNotNull((Object)myManager, (String)"myManager");
        this.myManager = myManager;
        Path path = configDir.toPath();
        if (path == null) {
            Intrinsics.throwNpe();
        }
        this.myConfigDir = path;
        this.myFileStorages = new HashSet();
        this.mySchemeStorages = new HashSet();
        this.myOSNames = new HashMap();
        this.addConfigs((Function2)new Function2<Class<?>, String, Unit>(){

            public final void invoke(@NotNull Class<?> clazz, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                if (Intrinsics.areEqual(clazz, KeymapManagerImpl.class)) {
                    this.getMyOSNames().put(name, CloudConfigClientUtil.getOS() + "." + name);
                }
            }
        }, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }
}

