/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseDragGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.scene.input.MouseEvent;

public class SelectAndMoveInGridGesture
extends AbstractMouseDragGesture {
    private final FXOMInstance gridPaneInstance;
    private final GridSelectionGroup.Type feature;
    private final int featureIndex;

    public SelectAndMoveInGridGesture(ContentPanelController contentPanelController, FXOMInstance gridPaneInstance, GridSelectionGroup.Type feature, int featureIndex) {
        super(contentPanelController);
        this.gridPaneInstance = gridPaneInstance;
        this.feature = feature;
        this.featureIndex = featureIndex;
    }

    public FXOMInstance getGridPaneInstance() {
        return this.gridPaneInstance;
    }

    public GridSelectionGroup.Type getFeature() {
        return this.feature;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    @Override
    protected void mousePressed(MouseEvent e) {
        boolean extendKeyDown;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        boolean bl = extendKeyDown = EditorPlatform.isContinuousSelectKeyDown(e) || EditorPlatform.isNonContinousSelectKeyDown(e);
        if (selection.getGroup() instanceof GridSelectionGroup) {
            if (extendKeyDown) {
                selection.toggleSelection(this.gridPaneInstance, this.feature, this.featureIndex);
            } else {
                selection.select(this.gridPaneInstance, this.feature, this.featureIndex);
            }
        } else {
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            selection.select(this.gridPaneInstance, this.feature, this.featureIndex);
        }
    }

    @Override
    protected void mouseDragDetected(MouseEvent e) {
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        if (selection.isSelected(this.gridPaneInstance, this.feature, this.featureIndex)) {
            System.out.println("SelectAndMoveInGridGesture.mouseDragDetected: will start column/row drag...");
        }
    }

    @Override
    protected void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void mouseExited(MouseEvent e) {
    }
}

