/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.SplitPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractNodeHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AdjustDividerGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public class SplitPaneHandles
extends AbstractNodeHandles<SplitPane> {
    private final Group grips = new Group();

    public SplitPaneHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, SplitPane.class);
        this.getRootNode().getChildren().add((Object)this.grips);
    }

    @Override
    protected void layoutDecoration() {
        super.layoutDecoration();
        this.adjustGripCount();
        double[] positions = ((SplitPane)this.getSceneGraphObject()).getDividerPositions();
        int count = positions.length;
        for (int i = 0; i < count; ++i) {
            this.layoutDivider(i);
        }
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractGesture result;
        int gripIndex;
        int gripCount = this.grips.getChildren().size();
        ObservableList gripNodes = this.grips.getChildren();
        for (gripIndex = 0; gripIndex < gripCount && gripNodes.get(gripIndex) != node; ++gripIndex) {
        }
        if (gripIndex < gripCount) {
            assert (gripNodes.get(gripIndex) == node);
            result = new AdjustDividerGesture(this.getContentPanelController(), this.getFxomInstance(), gripIndex);
        } else {
            result = super.findGesture(node);
        }
        return result;
    }

    private void adjustGripCount() {
        int dividerCount = ((SplitPane)this.getSceneGraphObject()).getDividerPositions().length;
        ObservableList gripChildren = this.grips.getChildren();
        while (gripChildren.size() < dividerCount) {
            gripChildren.add(this.makeGripLine());
        }
        while (gripChildren.size() > dividerCount) {
            gripChildren.remove(gripChildren.size() - 1);
        }
    }

    private Line makeGripLine() {
        Line result = new Line();
        result.setStrokeWidth(10.0);
        result.setStroke((Paint)Color.TRANSPARENT);
        switch (((SplitPane)this.getSceneGraphObject()).getOrientation()) {
            default: {
                result.setCursor(Cursor.H_RESIZE);
                break;
            }
            case VERTICAL: {
                result.setCursor(Cursor.V_RESIZE);
            }
        }
        this.attachHandles((Node)result);
        return result;
    }

    private void layoutDivider(int gripIndex) {
        double endY;
        double endX;
        double startY;
        double startX;
        assert (this.grips.getChildren().get(gripIndex) instanceof Line);
        SplitPaneDesignInfoX di = new SplitPaneDesignInfoX();
        double pos = ((SplitPane)this.getSceneGraphObject()).getDividerPositions()[gripIndex];
        double xy = di.dividerPositionToSplitPaneLocal((SplitPane)this.getSceneGraphObject(), pos);
        Bounds lb = ((SplitPane)this.getSceneGraphObject()).getLayoutBounds();
        switch (((SplitPane)this.getSceneGraphObject()).getOrientation()) {
            default: {
                startX = xy;
                startY = lb.getMinY();
                endX = xy;
                endY = lb.getMaxY();
                break;
            }
            case VERTICAL: {
                startX = lb.getMinX();
                startY = xy;
                endX = lb.getMaxX();
                endY = xy;
            }
        }
        boolean snapToPixel = true;
        Point2D startPoint = this.sceneGraphObjectToDecoration(startX, startY, true);
        Point2D endPoint = this.sceneGraphObjectToDecoration(endX, endY, true);
        Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
        gripLine.setStartX(startPoint.getX());
        gripLine.setStartY(startPoint.getY());
        gripLine.setEndX(endPoint.getX());
        gripLine.setEndY(endPoint.getY());
    }

    private void attachHandles(Node node) {
        SplitPaneHandles.attachHandles(node, this);
    }
}

