/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.ExpandExpressionReferenceJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.ExpandIntrinsicReferenceJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCloner;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;

public class ExpandReferenceJob
extends Job {
    private final Job subJob;

    public ExpandReferenceJob(FXOMNode reference, FXOMCloner cloner, EditorController editorController) {
        super(editorController);
        if (reference instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)reference;
            this.subJob = new ExpandIntrinsicReferenceJob(fxomIntrinsic, cloner, this.getEditorController());
        } else if (reference instanceof FXOMPropertyT) {
            FXOMPropertyT fxomProperty = (FXOMPropertyT)reference;
            this.subJob = new ExpandExpressionReferenceJob(fxomProperty, cloner, this.getEditorController());
        } else {
            throw new RuntimeException("Bug");
        }
    }

    @Override
    public boolean isExecutable() {
        return this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        this.subJob.execute();
    }

    @Override
    public void undo() {
        this.subJob.undo();
    }

    @Override
    public void redo() {
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        return this.subJob.getDescription();
    }
}

