/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveCollectionItemJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class RemoveObjectJob
extends Job {
    private final Job subJob;

    public RemoveObjectJob(FXOMObject targetObject, EditorController editorController) {
        super(editorController);
        assert (targetObject != null);
        assert (targetObject.getParentProperty() != null || targetObject.getParentCollection() != null);
        if (targetObject.getParentProperty() != null) {
            this.subJob = new RemovePropertyValueJob(targetObject, editorController);
        } else {
            assert (targetObject.getParentCollection() != null);
            this.subJob = new RemoveCollectionItemJob(targetObject, editorController);
        }
    }

    @Override
    public boolean isExecutable() {
        return this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        this.subJob.execute();
    }

    @Override
    public void undo() {
        this.subJob.undo();
    }

    @Override
    public void redo() {
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

