/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.grails.builder;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.compiler.GrailsCompilerRtMarker;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;

public class GrailsBuilderExtension
implements GroovyBuilderExtension {
    public static final Pattern CORE_JAR_PATTERN = Pattern.compile("grails-core-(\\d[^-]*(?:-SNAPSHOT)?)\\.jar");

    @NotNull
    public Collection<String> getCompilationClassPath(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        for (JpsModule module : chunk.getModules()) {
            if (!GrailsBuilderExtension.shouldInjectGrails(module)) continue;
            Set<String> set = Collections.singleton(PathManager.getJarPathForClass(GrailsCompilerRtMarker.class));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        return list;
    }

    private static boolean shouldInjectGrails(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "shouldInjectGrails"));
        }
        String version = GrailsBuilderExtension.getGrailsVersion(module);
        return GrailsBuilderExtension.shouldInjectGrails(version);
    }

    @Contract(value="null -> false")
    private static boolean shouldInjectGrails(@Nullable String version) {
        return version != null && VersionComparatorUtil.compare((String)version, (String)"3.0") < 0;
    }

    @Nullable
    private static String getGrailsVersion(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getGrailsVersion"));
        }
        String foundVersion = null;
        for (JpsDependencyElement dependencyElement : module.getDependenciesList().getDependencies()) {
            JpsLibrary library;
            if (!(dependencyElement instanceof JpsLibraryDependency) || (library = ((JpsLibraryDependency)dependencyElement).getLibrary()) == null) continue;
            for (File file : library.getFiles(JpsOrderRootType.COMPILED)) {
                Matcher matcher = CORE_JAR_PATTERN.matcher(file.getName());
                if (!matcher.matches()) continue;
                if (foundVersion == null) {
                    foundVersion = matcher.group(1);
                    continue;
                }
                if (VersionComparatorUtil.compare((String)foundVersion, (String)matcher.group(1)) == 0) continue;
                return null;
            }
        }
        return foundVersion;
    }

    @NotNull
    public Collection<String> getCompilationUnitPatchers(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        HashSet<String> res = new HashSet<String>();
        for (JpsModule module : chunk.getModules()) {
            String grailsVersion = GrailsBuilderExtension.getGrailsVersion(module);
            if (!GrailsBuilderExtension.shouldInjectGrails(grailsVersion)) continue;
            res.add("org.jetbrains.groovy.grails.compiler.GrailsJUnitPatcher");
            if (grailsVersion.compareTo("1.2") < 0) {
                res.add("org.jetbrains.groovy.grails.compiler.GrailsDomainClassPatcher");
                continue;
            }
            if (grailsVersion.compareTo("2.0") < 0) continue;
            res.add("org.jetbrains.groovy.grails.compiler.EmptyGrailsAwarePatcher");
            res.add("org.jetbrains.groovy.grails.compiler.Grails2_0_JUnitPatcher");
        }
        HashSet<String> hashSet = res;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        return hashSet;
    }
}

