/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.uml.model.UmlRelationship;
import java.awt.Point;
import javax.swing.JComponent;

public class UmlUtils {
    private static final UmlRelationship[] KNOWN_RELATIONSHIPS = new UmlRelationship[]{UmlRelationship.GENERALIZATION, UmlRelationship.REALIZATION, UmlRelationship.INTERFACE_GENERALIZATION, UmlRelationship.ANNOTATION};

    private UmlUtils() {
    }

    public static Point getNodeCoordinatesOnScreen(Node node, Graph2DView view) {
        Graph2D graph2D = (Graph2D)node.getGraph();
        Point viewPoint = ((Graph2DView)graph2D.getCurrentView()).getViewPoint();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        double x = nodeRealizer.getX();
        double y = nodeRealizer.getY();
        JComponent owner = view.getCanvasComponent();
        double oX = owner.getLocationOnScreen().getX();
        double oY = owner.getLocationOnScreen().getY();
        double pX = (x - (double)viewPoint.x) * view.getZoom() + oX;
        double pY = (y - (double)viewPoint.y) * view.getZoom() + oY;
        pX = pX < oX ? oX : pX;
        return new Point((int)pX, (int)pY);
    }

    public static void updateAfterCategoryChange(DiagramBuilder builder) {
        Graph2D graph = builder.getGraph();
        Project project = builder.getProject();
        Layouter layouter = GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)graph).getCurrentLayouter();
        builder.updateGraph();
        GraphManager.getGraphManager().createBufferedLayouter(layouter).doLayout((LayoutGraph)graph);
        if (DiagramConfiguration.getConfiguration().fitContentAfterLayout) {
            builder.getView().fitContent();
        }
        builder.getView().getGraph2D().updateViews();
    }

    public static Point getPointBeneathHeader(Point p, DiagramBuilder builder) {
        return new Point(p.x, p.y + (int)(24.0 * builder.getView().getZoom()));
    }
}

