/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlDataModel;
import com.intellij.usages.UsageTarget;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowModuleUsagesAction
extends DiagramNodeIntentionAction<ModuleItem> {
    public ShowModuleUsagesAction() {
        super("Show Usages", null, AllIcons.Actions.Find);
    }

    public void perform(DiagramNode<ModuleItem> node, DiagramBuilder builder) {
        ShowModuleUsagesAction.createUsageTarget(node, builder).findUsages();
    }

    public boolean isAvailable(DiagramNode<ModuleItem> node) {
        return true;
    }

    public static UsageTarget createUsageTarget(final DiagramNode<ModuleItem> node, final DiagramBuilder builder) {
        return new UsageTarget(){

            public void findUsages() {
                ModuleItem selectedValue = (ModuleItem)node.getIdentifyingElement();
                ModulesUmlDataModel model = (ModulesUmlDataModel)builder.getDataModel();
                LibraryProjectStructureElement structureElement = selectedValue.isLibrary() ? new LibraryProjectStructureElement(model.getContext(), selectedValue.getLibrary()) : new ModuleProjectStructureElement(model.getContext(), selectedValue.getModule());
                Collection usages = model.getContext().getDaemonAnalyzer().getUsages((ProjectStructureElement)structureElement);
                JBList list = new JBList(usages);
                list.installCellRenderer(dom -> {
                    ProjectStructureElementUsage usage = (ProjectStructureElementUsage)dom;
                    ProjectStructureElement element = usage.getContainingElement();
                    JLabel label = new JLabel(element.getPresentableText(), usage.getIcon(), 2);
                    if (element instanceof ModuleProjectStructureElement) {
                        label.setText(((ModuleProjectStructureElement)element).getModule().getName());
                    }
                    return label;
                });
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Usages of " + selectedValue.getName()).setItemChoosenCallback(DiagramAction.createCallback((DiagramBuilder)builder, (PopupCallback)new PopupCallback.Adapter(() -> {
                    Object[] values;
                    for (Object value : values = list.getSelectedValues()) {
                        ProjectStructureElementUsage usage = (ProjectStructureElementUsage)value;
                        ProjectStructureElement element = usage.getContainingElement();
                        DiagramNode<ModuleItem> n = null;
                        if (element instanceof ModuleProjectStructureElement) {
                            n = model.addElement(new ModuleItem(((ModuleProjectStructureElement)element).getModule()));
                        } else if (element instanceof LibraryProjectStructureElement) {
                            n = model.addElement(new ModuleItem(((LibraryProjectStructureElement)element).getLibrary(), model.getProject()));
                        }
                        if (n == null) continue;
                        builder.createDraggedNode(n, n.getTooltip(), DiagramUtils.getBestPositionForNode((DiagramBuilder)builder));
                    }
                    builder.update(true, true);
                }, "Add elements to diagram"))).createPopup();
                Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode(node), (Graph2DView)builder.getView());
            }

            public void findUsagesInEditor(@NotNull FileEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uml/project/actions/ShowModuleUsagesAction$1", "findUsagesInEditor"));
                }
            }

            public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/project/actions/ShowModuleUsagesAction$1", "highlightUsages"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uml/project/actions/ShowModuleUsagesAction$1", "highlightUsages"));
                }
            }

            public boolean isValid() {
                return true;
            }

            public boolean isReadOnly() {
                return true;
            }

            @Nullable
            public VirtualFile[] getFiles() {
                return VirtualFile.EMPTY_ARRAY;
            }

            public void update() {
            }

            @Nullable
            public String getName() {
                return null;
            }

            @Nullable
            public ItemPresentation getPresentation() {
                return null;
            }

            public void navigate(boolean requestFocus) {
            }

            public boolean canNavigate() {
                return false;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }
}

