/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.project.DependencyPath;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlCategoryManager;
import com.intellij.uml.project.ModulesUmlEdge;
import com.intellij.uml.project.ModulesUmlNode;
import com.intellij.uml.project.ModulesUmlProvider;
import com.intellij.uml.project.UmlModulesRelationshipHelper;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesUmlDataModel
extends DiagramDataModel<ModuleItem> {
    @Nullable
    private final ModuleItem myInitialElement;
    private final VirtualFile myEditorFile;
    private final Set<ModuleItem> addedByUser = new HashSet<ModuleItem>();
    private final Set<ModuleItem> removedByUser = new HashSet<ModuleItem>();
    private final HashSet<ModulesUmlNode> myNodes = new HashSet();
    private final HashSet<ModulesUmlEdge> myEdges = new HashSet();
    private final ModificationTracker myModificationTracker;
    final MessageBusConnection myConnection;
    private final StructureConfigurableContext myContext;
    private long myModificationCount;

    public ModulesUmlDataModel(Project project, @Nullable ModuleItem moduleItem, VirtualFile file, DiagramPresentationModel model) {
        super(project, DiagramProvider.findByID((String)"MODULES"));
        this.myEditorFile = file;
        this.myInitialElement = moduleItem;
        this.myConnection = this.getProject().getMessageBus().connect();
        this.myConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModulesUmlDataModel.this.myModificationCount++;
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        this.myConnection.subscribe(ProjectTopics.MODULES);
        this.myModificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return ModulesUmlDataModel.this.myModificationCount + ProjectRootManager.getInstance((Project)ModulesUmlDataModel.this.getProject()).getModificationCount();
            }
        };
        final ModulesConfigurator configurator = new ModulesConfigurator(this.getProject());
        this.myContext = new StructureConfigurableContext(this.getProject(), configurator);
        this.myContext.resetLibraries();
        this.myContext.getDaemonAnalyzer().reset();
        Disposer.register((Disposable)this, (Disposable)this.myContext);
        Disposer.register((Disposable)this.myContext, (Disposable)new Disposable(){

            public void dispose() {
                configurator.disposeUIResources();
            }
        });
    }

    private Collection<ModuleItem> getDependentModulesAndLibs() {
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myInitialElement != null) {
            Module mainModule = this.myInitialElement.getModule();
            modules.add(mainModule);
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)mainModule).withoutSdk().withoutModuleSourceEntries();
            this.includeTestsIfNeeded(enumerator).forEachModule(module -> {
                items.add(new ModuleItem((Module)module));
                modules.add((Module)module);
                return true;
            });
        }
        for (Module module2 : modules) {
            OrderEnumerator librariesEnumerator = OrderEnumerator.orderEntries((Module)module2).librariesOnly();
            this.includeTestsIfNeeded(librariesEnumerator).forEachLibrary(library -> {
                items.add(new ModuleItem(module2, (Library)library, this.getProject()));
                return true;
            });
        }
        return items;
    }

    private OrderEnumerator includeTestsIfNeeded(OrderEnumerator enumerator) {
        if (!this.isTestDependenciesEnabled()) {
            enumerator = enumerator.productionOnly();
        }
        return enumerator;
    }

    @NotNull
    public Collection<DiagramNode<ModuleItem>> getNodes() {
        ArrayList<ModulesUmlNode> arrayList = new ArrayList<ModulesUmlNode>(this.myNodes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/project/ModulesUmlDataModel", "getNodes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<ModuleItem>> getEdges() {
        ArrayList<ModulesUmlEdge> arrayList = new ArrayList<ModulesUmlEdge>(this.myEdges);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/project/ModulesUmlDataModel", "getEdges"));
        }
        return arrayList;
    }

    @NotNull
    @NonNls
    public String getNodeName(DiagramNode<ModuleItem> node) {
        String string = ((ModuleItem)node.getIdentifyingElement()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/project/ModulesUmlDataModel", "getNodeName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdge(DiagramEdge<ModuleItem> edge) {
        if (edge instanceof ModulesUmlEdge) {
            int answer;
            ModulesUmlEdge modulesEdge = (ModulesUmlEdge)edge;
            ModuleItem source = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
            ModuleItem target = (ModuleItem)modulesEdge.getTarget().getIdentifyingElement();
            ExportableOrderEntry orderEntry = modulesEdge.findOrderEntry();
            if (source.isModule() && orderEntry != null && (answer = Messages.showYesNoDialog((Project)this.getProject(), (String)("Do you want to remove dependency from " + StringUtil.decapitalize((String)source.getPresentableName()) + " to " + StringUtil.decapitalize((String)target.getPresentableName()) + "?"), (String)"Remove Dependency", null)) == 0) {
                AccessToken token = WriteAction.start();
                try {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)source.getModule()).getModifiableModel();
                    model.removeOrderEntry((OrderEntry)modulesEdge.findOrderEntry((ModuleRootModel)model));
                    model.commit();
                }
                finally {
                    token.finish();
                }
                this.getBuilder().update(false, false);
            }
        }
    }

    public DiagramEdge<ModuleItem> createEdge(@NotNull DiagramNode<ModuleItem> from, @NotNull DiagramNode<ModuleItem> to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/uml/project/ModulesUmlDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/uml/project/ModulesUmlDataModel", "createEdge"));
        }
        if (from instanceof ModulesUmlNode && to instanceof ModulesUmlNode && ((ModuleItem)from.getIdentifyingElement()).isModule()) {
            ModuleItem target = (ModuleItem)to.getIdentifyingElement();
            Module fromModule = ((ModuleItem)from.getIdentifyingElement()).getModule();
            if (target.isModule()) {
                ModuleRootModificationUtil.addDependency((Module)fromModule, (Module)target.getModule());
            } else {
                ModuleRootModificationUtil.addDependency((Module)fromModule, (Library)target.getLibrary());
            }
        }
        return null;
    }

    public void removeNode(DiagramNode<ModuleItem> node) {
        this.removeElement((ModuleItem)node.getIdentifyingElement());
        this.refreshDataModel();
    }

    public boolean hasElement(ModuleItem element) {
        return this.findNode(element) != null;
    }

    public void refreshDataModel() {
        this.updateDataModel();
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = this.myModificationTracker;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/project/ModulesUmlDataModel", "getModificationTracker"));
        }
        return modificationTracker;
    }

    public synchronized void updateDataModel() {
        Module[] modules;
        this.myNodes.clear();
        this.myEdges.clear();
        ModulesUmlProvider umlProvider = (ModulesUmlProvider)this.getBuilder().getProvider();
        Set<ModuleItem> moduleItems = this.getItemsToShow();
        HashMap<ModuleItem, ModulesUmlNode> nodes = new HashMap<ModuleItem, ModulesUmlNode>();
        for (ModuleItem item : moduleItems) {
            ModulesUmlNode umlNode = new ModulesUmlNode(item, umlProvider);
            this.myNodes.add(umlNode);
            nodes.put(item, umlNode);
        }
        List<ModulesUmlEdge> edges = UmlModulesRelationshipHelper.generateEdges(nodes, this.getProject(), this.isTestDependenciesEnabled());
        this.myEdges.addAll(edges);
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            this.myContext.getDaemonAnalyzer().queueUpdate((ProjectStructureElement)new ModuleProjectStructureElement(this.myContext, module));
        }
    }

    private boolean isTestDependenciesEnabled() {
        return this.getBuilder().getPresentation().isCategoryEnabled(ModulesUmlCategoryManager.TEST);
    }

    public void refreshDataModel(List<DependencyPath> dependencyPaths) {
        this.removeAll();
        this.myNodes.clear();
        this.myEdges.clear();
        this.addedByUser.clear();
        block0: for (DependencyPath path : dependencyPaths) {
            Module[] modules = path.getPaths();
            int i = 0;
            for (Module module : modules) {
                this.addedByUser.add(new ModuleItem(module));
                if (++i == 10) continue block0;
            }
        }
        this.refreshDataModel();
        this.getBuilder().update(true, true);
        if (dependencyPaths.size() > 10) {
            DiagramAction.showNotification((String)"Only few paths have been shown", (DiagramBuilder)this.getBuilder());
        }
    }

    private Set<ModuleItem> getItemsToShow() {
        HashSet<ModuleItem> result = new HashSet<ModuleItem>();
        boolean libsEnabled = this.getBuilder().getPresentation().isCategoryEnabled(ModulesUmlCategoryManager.LIBRARIES);
        HashSet<ModuleItem> allItems = new HashSet<ModuleItem>();
        if (this.myInitialElement != null) {
            allItems.add(this.myInitialElement);
            if (this.myInitialElement.isModule()) {
                allItems.addAll(this.getDependentModulesAndLibs());
            }
        }
        allItems.addAll(this.addedByUser);
        for (ModuleItem item : allItems) {
            if (this.removedByUser.contains(item) || !libsEnabled && item.isLibrary()) continue;
            if (item.isDisposed()) {
                this.addedByUser.remove(item);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    @Nullable
    public DiagramNode<ModuleItem> findNode(ModuleItem item) {
        for (DiagramNode diagramNode : this.myNodes) {
            ModuleItem element = (ModuleItem)diagramNode.getIdentifyingElement();
            if (!element.equals(item)) continue;
            return diagramNode;
        }
        return null;
    }

    public boolean contains(ModuleItem item) {
        return this.findNode(item) != null;
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    public void removeElement(ModuleItem item) {
        DiagramNode<ModuleItem> node = this.findNode(item);
        this.addedByUser.remove(item);
        this.removedByUser.add(item);
        this.myNodes.remove(node);
        if (node == null) {
            return;
        }
        ArrayList<DiagramEdge> edges = new ArrayList<DiagramEdge>();
        for (DiagramEdge diagramEdge : this.myEdges) {
            if (diagramEdge.getTarget() != node && diagramEdge.getSource() != node) continue;
            edges.add(diagramEdge);
        }
        this.myEdges.removeAll(edges);
    }

    @Nullable
    public DiagramNode<ModuleItem> addElement(ModuleItem element) {
        if (this.findNode(element) != null) {
            return null;
        }
        this.addedByUser.add(element);
        this.removedByUser.remove(element);
        if (element.isLibrary() && this.getBuilder().getPresentation().getEnabledCategories().length == 0) {
            this.getBuilder().getPresentation().setCategoryEnabled(ModulesUmlCategoryManager.LIBRARIES, true);
        }
        return new ModulesUmlNode(element, (DiagramProvider<ModuleItem>)this.getProvider());
    }

    public VirtualFile getFile() {
        return this.myEditorFile;
    }
}

