/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryNavigatable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleItem {
    private final Module myModule;
    private final Library myLibrary;
    private final Project myProject;
    private Navigatable navigatable;
    @NonNls
    private static final String SEPARATOR = "-";
    @NonNls
    private static final String MODULE_PREFIX = "mdl-";
    @NonNls
    private static final String LIB_PREFIX = "lib-";
    @NonNls
    private static final String JAR_PREFIX = "jar-";
    public static final ModuleItem[] EMPTY_ARRAY = new ModuleItem[0];

    public ModuleItem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/uml/project/ModuleItem", "<init>"));
        }
        this(module, null, module.getProject());
    }

    public ModuleItem(@NotNull Library library, @NotNull Project project) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/uml/project/ModuleItem", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/project/ModuleItem", "<init>"));
        }
        this(null, library, project);
    }

    public Module getModule() {
        return this.myModule;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public static ModuleItem fromFQN(@NotNull String fqn, Project project) throws IllegalArgumentException {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/uml/project/ModuleItem", "fromFQN"));
        }
        if (fqn.length() < 5 || fqn.charAt(3) != '-') {
            throw new IllegalArgumentException("Wrong FQN");
        }
        String prefix = fqn.substring(0, 4);
        String name = fqn.substring(4);
        if (MODULE_PREFIX.equals(prefix)) {
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(name);
            if (module == null) {
                throw new IllegalArgumentException("Wrong FQN");
            }
            return new ModuleItem(module);
        }
        if (LIB_PREFIX.equals(prefix)) {
            for (Library library : ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
                if (!name.equals(library.getName())) continue;
                return new ModuleItem(library, project);
            }
        }
        throw new IllegalArgumentException("Wrong FQN");
    }

    ModuleItem(Module module, Library library, Project project) {
        this.myModule = module;
        this.myLibrary = library;
        this.myProject = project;
    }

    public boolean isModule() {
        return this.myLibrary == null;
    }

    public boolean isLibrary() {
        return this.myLibrary != null;
    }

    public Project getProject() {
        return this.myProject;
    }

    private String getPrefix() {
        if (this.isModule()) {
            return MODULE_PREFIX;
        }
        if (this.isLibrary()) {
            return LIB_PREFIX;
        }
        return JAR_PREFIX;
    }

    public String getName() {
        if (this.isModule()) {
            return this.myModule.getName();
        }
        if (this.isLibrary()) {
            String name = this.myLibrary.getName();
            if (name != null) {
                return name;
            }
            if (!Disposer.isDisposed((Disposable)this.myLibrary)) {
                String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
                if (urls.length > 0) {
                    return PathUtil.getFileName((String)StringUtil.trimEnd((String)urls[0], (String)"!/"));
                }
                return "Unnamed empty library";
            }
        }
        return "-unknown-";
    }

    public String getQualifiedName() {
        return this.getPrefix() + this.getName();
    }

    public Icon getIcon() {
        if (this.isModule()) {
            return PlatformIcons.CONTENT_ROOT_ICON_CLOSED;
        }
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleItem that = (ModuleItem)o;
        return this.getQualifiedName().equals(that.getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public String toString() {
        return this.getPresentableName();
    }

    public String getPresentableName() {
        return (this.isLibrary() ? "Library '" : "Module '") + this.getName() + "'";
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (this.navigatable == null) {
            if (this.isModule()) {
                this.navigatable = new ModuleNavigatable(this.getModule());
            } else if (this.myModule != null) {
                this.navigatable = new LibraryNavigatable(this.myLibrary, this.myModule);
            }
        }
        return this.navigatable;
    }

    public boolean isDisposed() {
        return this.myLibrary == null ? this.myModule.isDisposed() : ((LibraryEx)this.myLibrary).isDisposed();
    }
}

