/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.actions.CreateNewMethodDialog;
import com.intellij.uml.java.actions.NewJavaClassElement;
import com.intellij.uml.utils.UmlPsiUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;

public abstract class NewJavaMethodBase
extends NewJavaClassElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uml.java.actions.NewJavaMethodBase");

    public NewJavaMethodBase(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    public abstract boolean isConstructor();

    public abstract String getHelpRef();

    @Override
    public DiagramCategory getCategory() {
        return this.isConstructor() ? JavaUmlCategoryManager.CONSTRUCTORS : JavaUmlCategoryManager.METHODS;
    }

    @Override
    public Runnable createWriteAction(PsiClass myClass, DiagramBuilder builder) throws Exception {
        PsiMethod method;
        Project project = myClass.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (this.isConstructor()) {
            method = factory.createConstructor();
            method.setName(myClass.getName());
        } else {
            method = factory.createMethodFromText(myClass.isInterface() ? "void method();" : "public void method() {}", (PsiElement)myClass, LanguageLevel.HIGHEST);
        }
        try {
            CreateNewMethodDialog dialog = new CreateNewMethodDialog(project, method, myClass){

                protected String getHelpId() {
                    return NewJavaMethodBase.this.getHelpRef();
                }
            };
            if (!dialog.showAndGet()) {
                return null;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
            throw e;
        }
        return () -> {
            if (!this.isConstructor() && NewJavaMethodBase.isReturnStatementRequired(method, myClass)) {
                NewJavaMethodBase.insertReturnStatement(project, method);
            }
            if (method.hasModifierProperty("abstract")) {
                try {
                    PsiModifierList modifierList;
                    PsiCodeBlock body = method.getBody();
                    if (body != null) {
                        body.delete();
                    }
                    if ((modifierList = myClass.getModifierList()) != null) {
                        modifierList.setModifierProperty("abstract", true);
                    }
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            }
            PsiMethod[] methods = myClass.getMethods();
            PsiMethod[] constructors = myClass.getConstructors();
            PsiField[] fields = myClass.getFields();
            Object anchor = methods.length == 0 && fields.length == 0 ? myClass.getLBrace() : (methods.length != 0 ? (this.isConstructor() ? (constructors.length != 0 ? constructors[constructors.length - 1] : (fields.length == 0 ? myClass.getLBrace() : fields[fields.length - 1])) : methods[methods.length - 1]) : fields[fields.length - 1]);
            try {
                myClass.addAfter((PsiElement)method, anchor);
            }
            catch (IncorrectOperationException e1) {
                LOG.error((Throwable)e1);
            }
            new OptimizeImportsProcessor((AbstractLayoutCodeProcessor)new ReformatCodeProcessor(project, myClass.getContainingFile(), null, false)).run();
        };
    }

    @Override
    public boolean isEnabledOn(PsiElement element) {
        if (super.isEnabledOn(element)) {
            PsiClass psiClass = (PsiClass)element;
            return !this.isConstructor() || !psiClass.isInterface();
        }
        return false;
    }

    private static void insertReturnStatement(Project project, PsiMethod method) {
        UmlPsiUtil.runWriteActionInCommandProcessor(project, (PsiElement)method, () -> {
            PsiType type = method.getReturnType();
            if (type == null) {
                return;
            }
            if (PsiType.VOID.equals((Object)type)) {
                return;
            }
            String returnStatement = "return null;";
            if (type.equals(PsiType.BOOLEAN)) {
                returnStatement = "return false;";
            } else if (type instanceof PsiPrimitiveType && !type.equals(PsiType.NULL)) {
                returnStatement = "return 0;";
            }
            String code = returnStatement;
            UmlPsiUtil.runWriteActionInCommandProcessor(project, (PsiElement)method, () -> {
                try {
                    PsiStatement returnCode = JavaPsiFacade.getInstance((Project)project).getElementFactory().createStatementFromText(code, (PsiElement)method);
                    PsiCodeBlock body = method.getBody();
                    if (body == null) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
                    } else {
                        body.add((PsiElement)returnCode);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            });
        });
    }

    private static boolean isReturnStatementRequired(PsiMethod method, PsiClass container) {
        if (container.isInterface()) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || returnType.equals(PsiType.VOID) || returnType.equals(PsiType.NULL)) {
            return false;
        }
        PsiModifierList modifiers = method.getModifierList();
        return !modifiers.hasModifierProperty("abstract");
    }
}

