/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uml.utils.UmlBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class NewJavaClassElement
extends DiagramCreateNewNodeElementAction<PsiElement, Runnable> {
    public NewJavaClassElement(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    public boolean isEnabledOn(PsiElement element) {
        return element instanceof PsiClass;
    }

    @Nullable
    public final Runnable prepare(PsiElement element, DiagramBuilder builder) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (!NewJavaClassElement.prepareClassForWrite(psiClass)) {
                return null;
            }
            try {
                return this.createWriteAction(psiClass, builder);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public abstract Runnable createWriteAction(PsiClass var1, DiagramBuilder var2) throws Exception;

    public abstract DiagramCategory getCategory();

    public final void execute(DiagramBuilder builder, Runnable run, AnActionEvent e) {
        run.run();
        DiagramCategory category = this.getCategory();
        boolean enabled = builder.getPresentation().isCategoryEnabled(category);
        if (!enabled) {
            builder.getPresentation().setCategoryEnabled(category, true);
            builder.update(false, true);
        }
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)UmlBundle.message("class.is.readonly", psiClass.getName()), (String)UmlBundle.message("error", new Object[0]));
        }
        return prepared;
    }
}

