/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewClassOnUmlDialog
extends DialogWrapper {
    private JTextField myClassName;
    private ComboboxWithBrowseButton myDir;
    private JPanel myPanel;
    private JPanel myDirPanel;
    private final PsiPackage myPsiPackage;
    private ReferenceEditorComboWithBrowseButton myPackageName;

    protected NewClassOnUmlDialog(PsiPackage psiPackage) {
        super(psiPackage.getProject());
        this.myPsiPackage = psiPackage;
        this.$$$setupUI$$$();
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myDirPanel.add((Component)this.myPackageName, "Center");
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassName;
    }

    private void createUIComponents() {
        Project project = this.myPsiPackage.getProject();
        this.myPackageName = new ReferenceEditorComboWithBrowseButton(null, this.myPsiPackage.getQualifiedName(), project, false, "uml.new.java.class");
        DestinationFolderComboBox folderComboBox = new DestinationFolderComboBox(){

            public String getTargetPackage() {
                return NewClassOnUmlDialog.this.myPackageName.getText();
            }
        };
        folderComboBox.setData(project, new PackageWrapper(this.myPsiPackage).getDirectories()[0], (EditorComboBox)this.myPackageName.getChildComponent());
        this.myDir = folderComboBox;
    }

    public PsiDirectory getPsiDirectory() {
        return ((DirectoryChooser.ItemWrapper)this.myDir.getComboBox().getSelectedItem()).getDirectory();
    }

    public String getClassName() {
        return this.myClassName.getText();
    }

    protected ValidationInfo doValidate() {
        String className = this.myClassName.getText();
        if (!PsiNameHelper.getInstance((Project)this.myPsiPackage.getProject()).isIdentifier(className)) {
            return new ValidationInfo("Bad class name", (JComponent)this.myClassName);
        }
        PsiDirectory directory = this.getPsiDirectory();
        if (directory == null) {
            return new ValidationInfo("Directory shouldn't be empty", (JComponent)this.myDir);
        }
        String name = className + ".java";
        if (directory.findFile(name) != null || directory.findSubdirectory(name) != null) {
            return new ValidationInfo(name + " already exists", (JComponent)this.myClassName);
        }
        return super.doValidate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Package:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Target directory:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDir;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myDirPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

