/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramPsiScopeManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlColorManager;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.JavaUmlExtras;
import com.intellij.uml.java.JavaUmlRelationshipManager;
import com.intellij.uml.java.JavaUmlVfsResolver;
import com.intellij.uml.java.JavaUmlVisibilityManager;
import com.intellij.uml.java.actions.NewEnumConstant;
import com.intellij.uml.java.actions.NewJavaClass;
import com.intellij.uml.java.actions.NewJavaConstructor;
import com.intellij.uml.java.actions.NewJavaEnum;
import com.intellij.uml.java.actions.NewJavaField;
import com.intellij.uml.java.actions.NewJavaInterface;
import com.intellij.uml.java.actions.NewJavaMethod;
import com.intellij.uml.utils.UmlBundle;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUmlProvider
extends DiagramProvider<PsiElement> {
    public static final String ID = "JAVA";
    private final JavaUmlVisibilityManager myVisibilityManager;
    private final JavaUmlCategoryManager myCategoryManager;
    private final JavaUmlElementManager myElementManager;
    private final JavaUmlVfsResolver myVfsResolver;
    private final JavaUmlColorManager myColorManager = new JavaUmlColorManager();
    private final JavaUmlRelationshipManager myRelationshipManager = new JavaUmlRelationshipManager();
    private final JavaUmlExtras myExtras = new JavaUmlExtras();
    private static final DiagramEdgeCreationPolicy<PsiElement> EDGE_CREATION_POLICY = new DiagramEdgeCreationPolicy<PsiElement>(){

        public boolean acceptSource(@NotNull DiagramNode<PsiElement> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/uml/java/JavaUmlProvider$1", "acceptSource"));
            }
            if (!(source.getIdentifyingElement() instanceof PsiClass)) {
                return false;
            }
            PsiClass psiClass = (PsiClass)source.getIdentifyingElement();
            PsiFile file = psiClass.getContainingFile();
            Project prj = psiClass.getProject();
            if (file == null) {
                return false;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            return ProjectRootManager.getInstance((Project)prj).getFileIndex().isInSource(virtualFile);
        }

        public boolean acceptTarget(@NotNull DiagramNode<PsiElement> target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/uml/java/JavaUmlProvider$1", "acceptTarget"));
            }
            return target.getIdentifyingElement() instanceof PsiClass;
        }
    };
    private DiagramCreateNewElementAction[] myActions = new DiagramCreateNewElementAction[]{new NewJavaClass(), new NewJavaInterface(), new NewJavaEnum()};
    private DiagramCreateNewNodeElementAction[] myNodeElementActions = new DiagramCreateNewNodeElementAction[]{new NewJavaField(), new NewJavaMethod(), new NewJavaConstructor(), new NewEnumConstant()};

    public JavaUmlProvider() {
        this.myVisibilityManager = new JavaUmlVisibilityManager();
        this.myCategoryManager = new JavaUmlCategoryManager();
        this.myElementManager = new JavaUmlElementManager();
        this.myVfsResolver = new JavaUmlVfsResolver();
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public JavaUmlVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public JavaUmlCategoryManager getNodeContentManager() {
        return this.myCategoryManager;
    }

    public JavaUmlElementManager getElementManager() {
        return this.myElementManager;
    }

    public JavaUmlVfsResolver getVfsResolver() {
        return this.myVfsResolver;
    }

    public JavaUmlRelationshipManager getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public String getPresentableName() {
        return UmlBundle.message("uml.java.presentable.name", new Object[0]);
    }

    public DiagramDataModel<PsiElement> createDataModel(@NotNull Project project, @Nullable PsiElement element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/java/JavaUmlProvider", "createDataModel"));
        }
        return new JavaUmlDataModel(project, element, file, presentationModel);
    }

    public DiagramColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public JavaUmlExtras getExtras() {
        JavaUmlExtras javaUmlExtras = this.myExtras;
        if (javaUmlExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlProvider", "getExtras"));
        }
        return javaUmlExtras;
    }

    public DiagramEdgeCreationPolicy<PsiElement> getEdgeCreationPolicy() {
        return EDGE_CREATION_POLICY;
    }

    public DiagramCreateNewElementAction[] getCreateNewActions() {
        return this.myActions;
    }

    public DiagramCreateNewNodeElementAction<PsiElement, ?>[] getCreateNewNodeElementActions() {
        return this.myNodeElementActions;
    }

    public DiagramScopeManager<PsiElement> createScopeManager(Project project) {
        return new DiagramPsiScopeManager(project);
    }

    public boolean isDumbAware() {
        return false;
    }
}

