/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.ide.structureView.impl.java.PropertyGroup;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProperty
implements Iconable {
    private String myName;
    private PsiType myType;
    private Icon myIcon;
    private boolean myDeprecated;
    private boolean myPhysical;
    private final PsiMethod myMethod;

    private JavaProperty(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/uml/java/JavaProperty", "<init>"));
        }
        this.myMethod = method;
        this.myName = PropertyUtil.getPropertyName((PsiMethod)method);
        this.myType = PropertyUtil.getPropertyType((PsiMember)method);
        PsiModifierList modifierList = method.getModifierList();
        boolean isStatic = modifierList.hasExplicitModifier("static");
        boolean isRead = PropertyUtil.findPropertyGetter((PsiClass)method.getContainingClass(), (String)this.myName, (boolean)isStatic, (boolean)false) != null;
        boolean isWrite = PropertyUtil.findPropertySetter((PsiClass)method.getContainingClass(), (String)this.myName, (boolean)isStatic, (boolean)false) != null;
        this.myIcon = JavaProperty.getIcon(isRead, isWrite, isStatic);
        this.myDeprecated = method.isDeprecated();
        this.myPhysical = method.isPhysical();
    }

    public PsiMethod getPropertyMethod() {
        return this.myMethod;
    }

    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    @Nullable
    private static Icon getIcon(boolean isRead, boolean isWrite, boolean isStatic) {
        if (isRead) {
            if (isWrite) {
                return isStatic ? PropertyGroup.PROPERTY_READ_WRITE_STATIC_ICON : PropertyGroup.PROPERTY_READ_WRITE_ICON;
            }
            return isStatic ? PropertyGroup.PROPERTY_READ_STATIC_ICON : PropertyGroup.PROPERTY_READ_ICON;
        }
        if (isWrite) {
            return isStatic ? PropertyGroup.PROPERTY_WRITE_STATIC_ICON : PropertyGroup.PROPERTY_WRITE_ICON;
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public PsiType getType() {
        return this.myType;
    }

    public Icon getIcon(int flags) {
        return this.myIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaProperty that = (JavaProperty)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    @Nullable
    public static JavaProperty create(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            Map allProperties = PropertyUtil.getAllProperties((PsiClass)containingClass, (boolean)true, (boolean)true, (boolean)false);
            String name = PropertyUtil.getPropertyName((PsiMethod)method);
            if (name != null && allProperties.containsKey(name)) {
                return new JavaProperty((PsiMethod)allProperties.get(name));
            }
        }
        return null;
    }

    @Nullable
    public static JavaProperty create(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/uml/java/JavaProperty", "create"));
        }
        PsiClass cls = field.getContainingClass();
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null || cls == null) {
            return null;
        }
        boolean isStatic = modifierList.hasModifierProperty("static");
        if (isStatic) {
            return null;
        }
        Map allProperties = PropertyUtil.getAllProperties((PsiClass)cls, (boolean)true, (boolean)true, (boolean)false);
        for (PsiMethod method : allProperties.values()) {
            if (PropertyUtil.findPropertyFieldByMember((PsiMember)method) != field) continue;
            return JavaProperty.create(method);
        }
        return null;
    }

    public static Collection<JavaProperty> getAllProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/uml/java/JavaProperty", "getAllProperties"));
        }
        HashSet<JavaProperty> properties = new HashSet<JavaProperty>();
        for (PsiMethod method : psiClass.getMethods()) {
            JavaProperty property = JavaProperty.create(method);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }
}

