/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.renderers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeRenderer;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.uml.core.renderers.UmlNoteContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DefaultUmlRenderer
extends AbstractColoredNodeCellRenderer
implements DiagramNodeRenderer {
    final DiagramBuilder myBuilder;
    private static final Point NULL_POINT = new Point(0, 0);

    public DefaultUmlRenderer(@NotNull DiagramBuilder builder, ModificationTracker modificationTracker) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/core/renderers/DefaultUmlRenderer", "<init>"));
        }
        super(modificationTracker);
        this.myBuilder = builder;
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
        this.tuneNode(realizer, wrapper, NULL_POINT);
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper, Point point) {
        wrapper.removeAll();
        DiagramNode umlNode = this.myBuilder.getNodeObject(realizer.getNode());
        if (umlNode != null) {
            JComponent c = this.myBuilder.getProvider().getExtras().createNodeComponent(umlNode, this.myBuilder, point, wrapper);
            if (wrapper.getClientProperty("cell.editor") == Boolean.TRUE) {
                c.putClientProperty("cell.editor", Boolean.TRUE);
            }
            wrapper.add((Component)c, "Center");
        }
    }

    protected JComponent getRendererComponent(Graph2DView view, NodeRealizer realizer, Object object, boolean sel) {
        DiagramNode node = this.myBuilder.getNodeObject(realizer.getNode());
        if (node instanceof DiagramNoteNode) {
            return new UmlNoteContainer((DiagramNoteNode)node, this.myBuilder, NULL_POINT);
        }
        return super.getRendererComponent(view, realizer, object, sel);
    }

    public int getSelectionBorderWidth() {
        return 1;
    }

    public Color getSelectionColor() {
        return super.getSelectionColor();
    }
}

