/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.scopes;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.uml.core.actions.visibility.DeselectedVisibilityIcon;
import com.intellij.uml.core.actions.visibility.SelectedVisibilityIcon;
import javax.swing.Icon;

public class UmlChangeScopeAction
extends DiagramAction {
    private static final SelectedVisibilityIcon SELECTED_ICON = new SelectedVisibilityIcon();
    private static final DeselectedVisibilityIcon DESELECTED_ICON = new DeselectedVisibilityIcon();
    private final DiagramScopeManager myMgr;
    private final NamedScope myScope;
    private final DiagramBuilder myBuilder;

    public UmlChangeScopeAction(DiagramScopeManager mgr, NamedScope scope, DiagramBuilder builder) {
        super(scope.getName(), null, null);
        this.myMgr = mgr;
        this.myScope = scope;
        this.myBuilder = builder;
    }

    public void perform(AnActionEvent e) {
        this.myMgr.setCurrentScope(this.myScope);
        this.myBuilder.getDataModel().refreshDataModel();
        this.myBuilder.update(true, this.myBuilder.isPopupMode());
        this.myBuilder.getGraph().updateViews();
    }

    public String getActionName() {
        return "Change Scope to " + this.myScope.getName();
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(this.getActionIcon());
    }

    private Icon getActionIcon() {
        return this.myScope == this.myMgr.getCurrentScope() ? SELECTED_ICON : DESELECTED_ICON;
    }
}

