/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.presentation.EdgeInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphComponent;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlFileEditorImpl
extends UserDataHolderBase
implements DiagramFileEditor,
PossiblyDumbAware {
    private final UmlGraphComponent myPanel;
    private DiagramBuilder myBuilder;
    private final Graph2D myGraph;
    private final Object myElement;
    @NonNls
    private static final String NAME = "UML";
    private final DiagramState myState;
    private DiagramState myStateFromFile;
    private boolean initialized;
    private boolean fitOnStartupFlag = false;
    private final VirtualFile myFile;
    private final DiagramProvider myProvider;
    private DocumentReference myDocumentReference;
    private boolean myInitIsDone = false;

    public UmlFileEditorImpl(Object element, boolean initialized, VirtualFile file, Project project) {
        this.initialized = initialized || ApplicationManager.getApplication().isUnitTestMode();
        this.myInitIsDone = initialized;
        this.myFile = file;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myDocumentReference = DocumentReferenceManager.getInstance().create(this.myFile);
        });
        this.myProvider = this.getProvider(file);
        assert (this.myProvider != null);
        Object object = this.myElement = element == null ? UmlFileEditorImpl.getFromFileState(this.myStateFromFile, project) : element;
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).setPresentableName(this.myProvider.getElementManager().getElementTitle(this.myElement));
        }
        DiagramBuilder diagramBuilder = this.myBuilder = file instanceof UmlVirtualFileSystem.UmlVirtualFile ? ((UmlVirtualFileSystem.UmlVirtualFile)file).getBuilder() : null;
        if (this.myBuilder == null) {
            this.myBuilder = UmlGraphBuilderFactory.create(project, this.myProvider, this.myElement, this.myFile);
        }
        DiagramPresentationModel presentationModel = this.myBuilder.getPresentationModel();
        DiagramState fromFile = null;
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && ((UmlVirtualFileSystem.UmlVirtualFile)file).getState() != null) {
            fromFile = this.myState = ((UmlVirtualFileSystem.UmlVirtualFile)file).getState();
        } else {
            this.myState = presentationModel.getPresentation();
            if (this.myElement != null) {
                this.myState.setOriginalFQN(this.myProvider.getVfsResolver().getQualifiedName(this.myElement));
            }
            if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
                ((UmlVirtualFileSystem.UmlVirtualFile)file).setState(this.myState);
            }
        }
        this.myGraph = this.myBuilder.getGraph();
        this.myBuilder.setEditor((DiagramFileEditor)this);
        presentationModel.registerActions();
        ActionToolbar toolbar = UmlGraphComponent.createToolbarPanel(UmlActions.createToolbarActions(this.myBuilder));
        this.myPanel = new UmlGraphComponent(this.myBuilder, toolbar);
        Disposer.register((Disposable)this, (Disposable)this.myPanel);
        GraphViewUtil.addDataProvider((Graph2DView)this.myBuilder.getView(), (DataProvider)this);
        DataManager.registerDataProvider((JComponent)toolbar.getComponent(), (DataProvider)this);
        MessageBusConnection connection = project.getMessageBus().connect();
        final ModificationTracker modificationTracker = this.myBuilder.getDataModel().getModificationTracker();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){
            long count;
            {
                this.count = modificationTracker.getModificationCount();
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/UmlFileEditorImpl$1", "selectionChanged"));
                }
                if (Comparing.equal((Object)event.getNewFile(), (Object)UmlFileEditorImpl.this.myFile) && this.count != modificationTracker.getModificationCount()) {
                    ApplicationManager.getApplication().invokeLater(() -> UmlFileEditorImpl.this.myBuilder.update(false, false));
                }
            }
        });
        if (fromFile != null) {
            this.myStateFromFile = fromFile;
            this.myInitIsDone = false;
        }
        this.myBuilder.getDataModel().setupScopeManager(element, false);
        this.myBuilder.getDataModel().setModelInitializationFinished();
        if (this.myStateFromFile != null) {
            Runnable fileStateInitializer = () -> this.setUmlState(this.myStateFromFile);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                fileStateInitializer.run();
            } else {
                ApplicationManager.getApplication().invokeLater(fileStateInitializer);
            }
        }
        this.initialized = UmlVirtualFileSystem.isInitialized(file);
    }

    @Nullable
    private static Object getFromFileState(DiagramState state, Project project) {
        DiagramProvider provider = DiagramProvider.findByID((String)state.getProviderID());
        return provider == null ? null : provider.getVfsResolver().resolveElementByFQN(state.getOriginalFQN(), project);
    }

    @Nullable
    public DiagramProvider getProvider(VirtualFile file) {
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            DiagramProvider umlProvider = ((UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider();
            if (umlProvider != null) {
                try {
                    return (DiagramProvider)umlProvider.getClass().newInstance();
                }
                catch (Exception exception) {}
            }
        } else if (file.getFileSystem() instanceof LocalFileSystem) {
            try {
                this.myStateFromFile = DiagramState.read((InputStream)file.getInputStream());
                return DiagramProvider.findByID((String)this.myStateFromFile.getProviderID());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlFileEditorImpl", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((Graph2DView)this.myGraph.getCurrentView()).getCanvasComponent();
    }

    @NonNls
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlFileEditorImpl", "getName"));
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/uml/UmlFileEditorImpl", "getState"));
        }
        this.myState.update(this.myBuilder, false);
        DiagramState diagramState = this.myState;
        if (diagramState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlFileEditorImpl", "getState"));
        }
        return diagramState;
    }

    public synchronized void setState(@NotNull FileEditorState editorState) {
        if (editorState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorState", "com/intellij/uml/UmlFileEditorImpl", "setState"));
        }
        if (!this.initialized && editorState instanceof DiagramState) {
            this.setUmlState((DiagramState)editorState);
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized && this.myInitIsDone;
    }

    public void setUmlState(DiagramState editorState) {
        DiagramVisibilityManager visibilityManager;
        DiagramState state;
        DiagramState diagramState = state = this.myStateFromFile == null ? editorState : this.myStateFromFile;
        if (state == null) {
            return;
        }
        DiagramDataModel model = this.myBuilder.getDataModel();
        ArrayList nodes = new ArrayList(model.getNodes());
        HashMap<String, DiagramNode> cache = new HashMap<String, DiagramNode>();
        DiagramVfsResolver resolver = this.myProvider.getVfsResolver();
        for (DiagramNode node : nodes) {
            cache.put(resolver.getQualifiedName(node.getIdentifyingElement()), node);
            model.removeNode(node);
        }
        DiagramScopeManager scopeManager = model.getScopeManager();
        if (scopeManager != null) {
            String currentScope = state.getCurrentScope();
            scopeManager.setCurrentScope(currentScope);
        }
        if ((visibilityManager = model.getVisibilityManager()) != null) {
            String visibility = state.getCurrentVisibility();
            for (VisibilityLevel visibilityLevel : visibilityManager.getVisibilityLevels()) {
                if (!visibilityLevel.getName().equals(visibility)) continue;
                visibilityManager.setCurrentVisibilityLevel(visibilityLevel);
                break;
            }
        }
        model.refreshDataModel();
        model.removeAll();
        Project project = this.myBuilder.getProject();
        this.myState.copyFrom(state);
        for (String string : state.getFQNs()) {
            DiagramNode umlNode = (DiagramNode)cache.get(string);
            if (umlNode == null) {
                Object cl = resolver.resolveElementByFQN(string, project);
                if (cl == null) continue;
                cache.put(string, model.addElement(cl));
                continue;
            }
            cache.put(string, model.addElement(umlNode.getIdentifyingElement()));
        }
        model.refreshDataModel();
        UmlFileEditorImpl.updateCache(model, cache, resolver);
        Map map = state.getNotes();
        for (String fqn : map.keySet()) {
            DiagramNode diagramNode = (DiagramNode)cache.get(fqn);
            if (diagramNode == null) continue;
            model.addNote(diagramNode, (String)map.get(fqn));
        }
        this.myBuilder.updateGraph();
        List selectedNodes = GraphViewUtil.getSelectedNodes((Graph2D)this.myBuilder.getGraph());
        for (Node node : selectedNodes) {
            this.myBuilder.getGraph().setSelected(node, false);
        }
        for (String fqn : state.getSelectedNodes()) {
            Node node;
            DiagramNode umlNode = (DiagramNode)cache.get(fqn);
            if (umlNode == null || (node = this.myBuilder.getNode(umlNode)) == null) continue;
            this.myGraph.setSelected(node, true);
        }
        this.myState.copyFrom(state);
        UIUtil.invokeLaterIfNeeded(() -> this.myBuilder.getPresentationModel().update());
        Runnable layoutInitializer = () -> {
            this.myBuilder.getView().setZoom(state.getZoom());
            this.myBuilder.getView().setCenter(state.getCenter().getX(), state.getCenter().getY());
            HashMap<DiagramNode, String> fqnCache = new HashMap<DiagramNode, String>();
            for (DiagramNode node : this.myBuilder.getNodeObjects()) {
                String fqn;
                if (node instanceof DiagramNoteNode) {
                    fqn = resolver.getQualifiedName(((DiagramNoteNode)node).getIdentifyingElement().getIdentifyingElement());
                    try {
                        Couple pair = (Couple)state.getNotesCoord().get(fqn);
                        this.myBuilder.getGraph().setLocation(this.myBuilder.getNode(node), ((Double)pair.first).doubleValue(), ((Double)pair.second).doubleValue());
                    }
                    catch (Exception pair) {}
                    continue;
                }
                fqn = resolver.getQualifiedName(node.getIdentifyingElement());
                if (fqn != null) {
                    fqnCache.put(node, fqn);
                }
                try {
                    double x = Double.parseDouble(state.getNodeX(fqn));
                    double y = Double.parseDouble(state.getNodeY(fqn));
                    this.myBuilder.getGraph().setLocation(this.myBuilder.getNode(node), x, y);
                }
                catch (Exception x) {}
            }
            for (DiagramEdge umlEdge : this.myBuilder.getEdgeObjects()) {
                EdgeInfo info;
                if (umlEdge instanceof DiagramNoteEdge) {
                    String fqn = (String)fqnCache.get(umlEdge.getSource());
                    info = state.getNoteEdgeCoord(fqn);
                } else {
                    String src = (String)fqnCache.get(umlEdge.getSource());
                    String trg = (String)fqnCache.get(umlEdge.getTarget());
                    info = state.getEdgeInfo(src, trg);
                }
                Edge edge = this.myBuilder.getEdge(umlEdge);
                if (info == null || edge == null || info.getPoints().size() <= 1) continue;
                List points = info.getPoints();
                EdgeLayout edgeLayout = this.myGraph.getEdgeLayout((Object)edge);
                if (edgeLayout == null) continue;
                edgeLayout.clearPoints();
                YPoint srcP = GraphManager.getGraphManager().createYPoint(((Double)((Couple)points.get(0)).getFirst()).doubleValue(), ((Double)((Couple)points.get(0)).getSecond()).doubleValue());
                YPoint trgP = GraphManager.getGraphManager().createYPoint(((Double)((Couple)points.get(points.size() - 1)).getFirst()).doubleValue(), ((Double)((Couple)points.get(points.size() - 1)).getSecond()).doubleValue());
                edgeLayout.setSourcePoint(srcP);
                edgeLayout.setTargetPoint(trgP);
                for (int i = 1; i < points.size() - 1; ++i) {
                    edgeLayout.addPoint(((Double)((Couple)points.get(i)).getFirst()).doubleValue(), ((Double)((Couple)points.get(i)).getSecond()).doubleValue());
                }
            }
            this.myInitIsDone = true;
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            layoutInitializer.run();
        } else {
            ApplicationManager.getApplication().invokeLater(layoutInitializer);
        }
        this.myStateFromFile = null;
    }

    private static void updateCache(DiagramDataModel model, Map<String, DiagramNode> cache, DiagramVfsResolver resolver) {
        for (DiagramNode node : model.getNodes()) {
            String fqn = resolver.getQualifiedName(node.getIdentifyingElement());
            if (!cache.containsKey(fqn)) continue;
            cache.put(fqn, node);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (!this.fitOnStartupFlag) {
            if (this.myElement != null) {
                this.myBuilder.getGraph().updateViews();
                ((Graph2DView)this.myGraph.getCurrentView()).fitContent();
            } else {
                this.myBuilder.updateGraph();
            }
            this.fitOnStartupFlag = true;
        }
        this.findAndSelectOriginNode();
    }

    private void findAndSelectOriginNode() {
        if (DiagramAction.getSelectedNodes((DiagramBuilder)this.myBuilder).size() > 0) {
            return;
        }
        for (Node node : this.myGraph.getNodeArray()) {
            DiagramNode umlNode = this.myBuilder.getNodeObject(node);
            if (umlNode == null || umlNode.getIdentifyingElement() != this.myElement) continue;
            this.myGraph.setSelected(node, true);
            return;
        }
        if (this.myGraph.N() > 0) {
            this.myGraph.setSelected(this.myGraph.firstNode(), true);
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uml/UmlFileEditorImpl", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uml/UmlFileEditorImpl", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        throw new UnsupportedOperationException("getCurrentLocation is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return GraphViewUtil.createStructureViewBuilder((Overview)GraphManager.getGraphManager().createOverview(this.myBuilder.getView()));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        Disposer.dispose((Disposable)this.myPanel);
    }

    @NonNls
    @Nullable
    public Object getData(@NonNls String dataId) {
        List selectedNodes;
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myBuilder.getProject();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        if (FileChooserKeys.DELETE_ACTION_AVAILABLE.is(dataId)) {
            return false;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selectedNodes = DiagramAction.getSelectedNodes((DiagramBuilder)this.myBuilder)).size() > 0) {
            Point point = UmlUtils.getNodeCoordinatesOnScreen(this.myBuilder.getNode((DiagramNode)selectedNodes.get(0)), this.myBuilder.getView());
            SwingUtilities.convertPointFromScreen(point, this.myBuilder.getView().getCanvasComponent());
            return UmlUtils.getPointBeneathHeader(point, this.myBuilder);
        }
        return UmlFileEditorImpl.getData(dataId, this.myBuilder);
    }

    @NonNls
    @Nullable
    public static Object getData(@NonNls String dataId, @NonNls DiagramBuilder myBuilder) {
        Object selectedElement;
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return myBuilder.getProject();
        }
        DiagramProvider provider = myBuilder.getProvider();
        Graph2D myGraph = myBuilder.getGraph();
        DiagramExtras extras = provider.getExtras();
        List list = GraphViewUtil.getSelectedNodes((Graph2D)myGraph);
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        for (Node node : list) {
            DiagramNode umlNode = myBuilder.getNodeObject(node);
            if (umlNode == null || umlNode instanceof DiagramNoteNode) continue;
            nodes.add(umlNode);
        }
        Object data = extras.getData(dataId, nodes, myBuilder);
        if (data != null) {
            return data;
        }
        DiagramNodeEditorManager manager = DiagramNodeEditorManager.getInstance();
        NodeCellEditor editor = manager.getCurrentCellEditor();
        DiagramNode selectedNode = list.size() == 1 ? myBuilder.getNodeObject((Node)list.get(0)) : null;
        Object object = selectedElement = selectedNode == null ? null : selectedNode.getIdentifyingElement();
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (editor != null) {
                return manager.getData(dataId);
            }
            return selectedElement instanceof PsiElement && ((PsiElement)selectedElement).isValid() ? selectedElement : null;
        }
        if (SelectInContext.DATA_KEY.is(dataId)) {
            if (selectedElement instanceof PsiElement) {
                PsiDirectory[] directories;
                PsiFile psiFile = ((PsiElement)selectedElement).getContainingFile();
                if (psiFile != null) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null) {
                        return new FileSelectInContext(myBuilder.getProject(), virtualFile);
                    }
                } else if (selectedElement instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)selectedElement).getDirectories()).length > 0) {
                    return new FileSelectInContext(myBuilder.getProject(), directories[0].getVirtualFile());
                }
            }
        } else {
            if (DiagramDataKeys.BUILDER.is(dataId)) {
                return myBuilder;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                if (editor != null) {
                    return manager.getData(dataId);
                }
                Object element = UmlFileEditorImpl.getData(CommonDataKeys.PSI_ELEMENT.getName(), myBuilder);
                if (element instanceof PsiElement) {
                    return ((PsiElement)element).getContainingFile();
                }
            } else {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    if (editor != null) {
                        return manager.getData(dataId);
                    }
                    return null;
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return "reference.uml.class.diagram";
                }
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    Graph2DView view = myBuilder.getView();
                    Component c = view.getComponent();
                    Point p = SwingUtilities.getRoot(c).getLocationOnScreen();
                    if (nodes.size() == 1) {
                        Point np = UmlUtils.getNodeCoordinatesOnScreen((Node)list.get(0), view);
                        np = UmlUtils.getPointBeneathHeader(np, myBuilder);
                        return new Rectangle(np.x - p.x, np.y - p.y, 0, 0);
                    }
                    Point sp = c.getLocationOnScreen();
                    return new Rectangle(sp.x - p.x + c.getWidth() / 3, sp.y - p.y + c.getHeight() * 3 / 7, 0, 0);
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    NodeCellEditor cellEditor = DiagramNodeEditorManager.getInstance().getCurrentCellEditor();
                    if (cellEditor != null) {
                        return DiagramNodeEditorManager.getInstance().getData(dataId);
                    }
                    ArrayList<NavigatablePsiElement> elements = new ArrayList<NavigatablePsiElement>();
                    for (Node node : list) {
                        Object element;
                        DiagramNode umlNode = myBuilder.getNodeObject(node);
                        if (umlNode == null || !((element = umlNode.getIdentifyingElement()) instanceof NavigatablePsiElement)) continue;
                        elements.add((NavigatablePsiElement)element);
                    }
                    if (!elements.isEmpty()) {
                        return elements.toArray(new NavigatablePsiElement[elements.size()]);
                    }
                }
            }
        }
        return null;
    }

    public DiagramBuilder getBuilder() {
        return this.myBuilder;
    }

    public Object getOriginalElement() {
        return this.myElement;
    }

    public VirtualFile getOriginalVirtualFile() {
        return this.myFile;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return this.myDocumentReference == null ? Collections.emptyList() : Arrays.asList(this.myDocumentReference);
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myProvider);
    }
}

