/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.utils.UmlFileConverter;
import com.intellij.uml.utils.VcsUtils;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlEditorProvider
implements FileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        UmlVirtualFileSystem.UmlVirtualFile umlVirtualFile;
        DiagramProvider provider;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "accept"));
        }
        if (file.getFileSystem() instanceof LocalFileSystem && "uml".equalsIgnoreCase(file.getExtension())) {
            if (UmlEditorProvider.isNewUmlFormat(file)) {
                return true;
            }
            if (UmlEditorProvider.isOldUmlFormat(file)) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return this.convertFile(project, file);
                }
                SwingUtilities.invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "lambda$accept$0"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "lambda$accept$0"));
                    }
                    this.convertFile(project, file);
                });
            }
            return false;
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && (provider = (umlVirtualFile = (UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider()) != null) {
            if (provider instanceof DumbAware && DumbService.isDumb((Project)project)) {
                return false;
            }
            return UmlEditorProvider.getElementFromFile(project, umlVirtualFile) != null || VcsUtils.isShowChangesFile(file);
        }
        return false;
    }

    private boolean convertFile(final Project project, final VirtualFile file) {
        Boolean success;
        if (Messages.showOkCancelDialog((Project)project, (String)"This file has old format. Would you like to convert it?", (String)"Old Diagram Format", (Icon)AllIcons.FileTypes.Diagram) == 0 && !(success = (Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                try {
                    VirtualFile copy = file.copy((Object)this, file.getParent(), file.getName() + ".bak.xml");
                    PsiFile xml = PsiManager.getInstance((Project)project).findFile(copy);
                    if (!(xml instanceof XmlFile)) {
                        throw new IOException();
                    }
                    Document doc = UmlFileConverter.convert(((XmlFile)xml).getDocument());
                    boolean result = DiagramState.writeXml((VirtualFile)file, (Project)project, (Document)doc);
                    copy.delete(null);
                    return result;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        })).booleanValue()) {
            Messages.showErrorDialog((Project)project, (String)"Can't save converted content into file. Check read-only status.", (String)"Error");
            return true;
        }
        return false;
    }

    private static boolean isNewUmlFormat(VirtualFile file) {
        try {
            String beginning = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            return beginning.contains("<Diagramm>") || beginning.contains("<Diagram>");
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isOldUmlFormat(VirtualFile file) {
        try {
            return VfsUtilCore.loadText((VirtualFile)file, (int)100).contains("<ClassDiagramm>");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    private static Object getElementFromFile(Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "getElementFromFile"));
        }
        DiagramProvider umlProvider = file.getUmlProvider();
        return umlProvider != null ? umlProvider.getVfsResolver().resolveElementByFQN(file.getFQN(), project) : null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "createEditor"));
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            FileEditor fileEditor = UmlEditorProvider.createEditorFromPsiElement(project, (UmlVirtualFileSystem.UmlVirtualFile)file);
            if (fileEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlEditorProvider", "createEditor"));
            }
            return fileEditor;
        }
        UmlFileEditorImpl umlFileEditorImpl = new UmlFileEditorImpl(null, false, file, project);
        if (umlFileEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlEditorProvider", "createEditor"));
        }
        return umlFileEditorImpl;
    }

    private static FileEditor createEditorFromPsiElement(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "createEditorFromPsiElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "createEditorFromPsiElement"));
        }
        boolean initialized = UmlVirtualFileSystem.isInitialized(file);
        return new UmlFileEditorImpl(UmlEditorProvider.getElementFromFile(project, file), initialized, file, project);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uml/UmlEditorProvider", "disposeEditor"));
        }
        VirtualFile file = ((UmlFileEditorImpl)editor).getOriginalVirtualFile();
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            DiagramState state = (DiagramState)editor.getState(FileEditorStateLevel.FULL);
            ((UmlVirtualFileSystem.UmlVirtualFile)file).setState(state);
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        UmlVirtualFileSystem.UmlVirtualFile vf;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/uml/UmlEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uml/UmlEditorProvider", "readState"));
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && (vf = (UmlVirtualFileSystem.UmlVirtualFile)file).getProject() == null) {
            vf.setProject(project);
        }
        DiagramState diagramState = DiagramState.read((Element)sourceElement);
        if (diagramState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlEditorProvider", "readState"));
        }
        return diagramState;
    }

    public void writeState(@NotNull FileEditorState editorState, @NotNull Project project, @NotNull Element element) {
        if (editorState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorState", "com/intellij/uml/UmlEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/UmlEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/UmlEditorProvider", "writeState"));
        }
        UmlEditorProvider.saveUmlState(editorState, element);
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        if ("UmlEditorProvider" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlEditorProvider", "getEditorTypeId"));
        }
        return "UmlEditorProvider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    public static void saveUmlState(@NotNull FileEditorState editorState, @NotNull Element root) {
        if (editorState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorState", "com/intellij/uml/UmlEditorProvider", "saveUmlState"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/uml/UmlEditorProvider", "saveUmlState"));
        }
        if (editorState instanceof DiagramState) {
            ((DiagramState)editorState).write(root);
        }
    }
}

