/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramActionsListener;
import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UmlActionsManagerImpl
extends DiagramActionsManager {
    private final List<DiagramActionsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void addListener(@NotNull DiagramActionsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uml/UmlActionsManagerImpl", "addListener"));
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void notifyUmlListeners(@NotNull DiagramBuilder builder, DiagramState oldState, PsiFile ... files) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/UmlActionsManagerImpl", "notifyUmlListeners"));
        }
        for (DiagramActionsListener listener : this.myListeners) {
            listener.actionPerformed(builder, oldState, files);
        }
    }

    public boolean removeListener(@NotNull DiagramActionsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uml/UmlActionsManagerImpl", "removeListener"));
        }
        return this.myListeners.remove(listener);
    }
}

