/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.tree.ModuleExportNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleProvideNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleRequireNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends ModuleVisitor {
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode() {
        super(393216);
    }

    public ModuleNode(int api, List<ModuleRequireNode> requires, List<ModuleExportNode> exports, List<String> uses, List<ModuleProvideNode> provides) {
        super(393216);
        this.requires = requires;
        this.exports = exports;
        this.uses = uses;
        this.provides = provides;
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void visitRequire(String module, int access) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(module, access));
    }

    @Override
    public void visitExport(String packaze, String ... modules) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        ArrayList<String> moduleList = null;
        if (modules != null) {
            moduleList = new ArrayList<String>(modules.length);
            for (int i = 0; i < modules.length; ++i) {
                moduleList.add(modules[i]);
            }
        }
        this.exports.add(new ModuleExportNode(packaze, moduleList));
    }

    @Override
    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(service);
    }

    @Override
    public void visitProvide(String service, String impl) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(service, impl));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor cv) {
        int i;
        ModuleVisitor mv = cv.visitModule();
        if (mv == null) {
            return;
        }
        if (this.requires != null) {
            for (i = 0; i < this.requires.size(); ++i) {
                this.requires.get(i).accept(mv);
            }
        }
        if (this.exports != null) {
            for (i = 0; i < this.exports.size(); ++i) {
                this.exports.get(i).accept(mv);
            }
        }
        if (this.uses != null) {
            for (i = 0; i < this.uses.size(); ++i) {
                mv.visitUse(this.uses.get(i));
            }
        }
        if (this.provides != null) {
            for (i = 0; i < this.provides.size(); ++i) {
                this.provides.get(i).accept(mv);
            }
        }
    }
}

