/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarTypeProcessor {
    public static final int VAR_NON_FINAL = 1;
    public static final int VAR_EXPLICIT_FINAL = 2;
    public static final int VAR_FINAL = 3;
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final Map<VarVersionPair, VarType> mapExprentMinTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, VarType> mapExprentMaxTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, Integer> mapFinalVars = new HashMap<VarVersionPair, Integer>();

    public VarTypeProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.methodDescriptor = md;
    }

    public void calculateVarTypes(RootStatement root, DirectGraph graph) {
        this.setInitVars(root);
        VarTypeProcessor.resetExprentTypes(graph);
        while (!this.processVarTypes(graph)) {
        }
    }

    private void setInitVars(RootStatement root) {
        boolean thisVar = !this.method.hasModifier(8);
        MethodDescriptor md = this.methodDescriptor;
        if (thisVar) {
            StructClass cl = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
            VarType clType = new VarType(8, 0, cl.qualifiedName);
            this.mapExprentMinTypes.put(new VarVersionPair(0, 1), clType);
            this.mapExprentMaxTypes.put(new VarVersionPair(0, 1), clType);
        }
        int varIndex = 0;
        for (int i = 0; i < md.params.length; ++i) {
            this.mapExprentMinTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), md.params[i]);
            this.mapExprentMaxTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), md.params[i]);
            varIndex += md.params[i].stackSize;
        }
        LinkedList<RootStatement> stack = new LinkedList<RootStatement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeFirst();
            List<VarExprent> lstVars = null;
            if (stat.type == 12) {
                lstVars = ((CatchAllStatement)stat).getVars();
            } else if (stat.type == 7) {
                lstVars = ((CatchStatement)stat).getVars();
            }
            if (lstVars != null) {
                for (VarExprent var : lstVars) {
                    this.mapExprentMinTypes.put(new VarVersionPair(var.getIndex(), 1), var.getVarType());
                    this.mapExprentMaxTypes.put(new VarVersionPair(var.getIndex(), 1), var.getVarType());
                }
            }
            stack.addAll(stat.getStats());
        }
    }

    private static void resetExprentTypes(DirectGraph graph) {
        graph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    if (expr.type == 12) {
                        ((VarExprent)expr).setVarType(VarType.VARTYPE_UNKNOWN);
                        continue;
                    }
                    if (expr.type != 3) continue;
                    ConstExprent constExpr = (ConstExprent)expr;
                    if (constExpr.getConstType().typeFamily != 2) continue;
                    constExpr.setConstType(new ConstExprent(constExpr.getIntValue(), constExpr.isBoolPermitted(), null).getConstType());
                }
                return 0;
            }
        });
    }

    private boolean processVarTypes(DirectGraph graph) {
        return graph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                return VarTypeProcessor.this.checkTypeExprent(exprent) ? 0 : 1;
            }
        });
    }

    private boolean checkTypeExprent(Exprent exprent) {
        for (Exprent expr : exprent.getAllExprents()) {
            if (this.checkTypeExprent(expr)) continue;
            return false;
        }
        if (exprent.type == 3) {
            Object pair;
            ConstExprent constExpr = (ConstExprent)exprent;
            if (constExpr.getConstType().typeFamily <= 2 && !this.mapExprentMinTypes.containsKey(pair = new VarVersionPair(constExpr.id, -1))) {
                this.mapExprentMinTypes.put((VarVersionPair)pair, constExpr.getConstType());
            }
        }
        CheckTypesResult result = exprent.checkExprTypeBounds();
        for (CheckTypesResult.ExprentTypePair entry : result.getLstMaxTypeExprents()) {
            if (entry.type.typeFamily == 6) continue;
            this.changeExprentType(entry.exprent, entry.type, 1);
        }
        boolean res = true;
        for (CheckTypesResult.ExprentTypePair entry : result.getLstMinTypeExprents()) {
            res &= this.changeExprentType(entry.exprent, entry.type, 0);
        }
        return res;
    }

    private boolean changeExprentType(Exprent exprent, VarType newType, int minMax) {
        boolean res = true;
        block0 : switch (exprent.type) {
            case 3: {
                VarType minInteger;
                ConstExprent constExpr = (ConstExprent)exprent;
                VarType constType = constExpr.getConstType();
                if (newType.typeFamily > 2 || constType.typeFamily > 2) {
                    return true;
                }
                if (newType.typeFamily == 2 && (minInteger = new ConstExprent((Integer)constExpr.getValue(), false, null).getConstType()).isStrictSuperset(newType)) {
                    newType = minInteger;
                }
            }
            case 12: {
                VarType newMaxType;
                VarVersionPair pair = null;
                if (exprent.type == 3) {
                    pair = new VarVersionPair(((ConstExprent)exprent).id, -1);
                } else if (exprent.type == 12) {
                    pair = new VarVersionPair((VarExprent)exprent);
                }
                if (minMax == 0) {
                    VarType newMinType;
                    VarType currentMinType = this.mapExprentMinTypes.get(pair);
                    if (currentMinType == null || newType.typeFamily > currentMinType.typeFamily) {
                        newMinType = newType;
                    } else {
                        if (newType.typeFamily < currentMinType.typeFamily) {
                            return true;
                        }
                        newMinType = VarType.getCommonSupertype(currentMinType, newType);
                    }
                    this.mapExprentMinTypes.put(pair, newMinType);
                    if (exprent.type == 3) {
                        ((ConstExprent)exprent).setConstType(newMinType);
                    }
                    if (currentMinType == null || newMinType.typeFamily <= currentMinType.typeFamily && !newMinType.isStrictSuperset(currentMinType)) break;
                    return false;
                }
                VarType currentMaxType = this.mapExprentMaxTypes.get(pair);
                if (currentMaxType == null || newType.typeFamily < currentMaxType.typeFamily) {
                    newMaxType = newType;
                } else {
                    if (newType.typeFamily > currentMaxType.typeFamily) {
                        return true;
                    }
                    newMaxType = VarType.getCommonMinType(currentMaxType, newType);
                }
                this.mapExprentMaxTypes.put(pair, newMaxType);
                break;
            }
            case 2: {
                return this.changeExprentType(((AssignmentExprent)exprent).getRight(), newType, minMax);
            }
            case 6: {
                FunctionExprent func = (FunctionExprent)exprent;
                switch (func.getFuncType()) {
                    case 36: {
                        res = this.changeExprentType(func.getLstOperands().get(1), newType, minMax) & this.changeExprentType(func.getLstOperands().get(2), newType, minMax);
                        break block0;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        res = this.changeExprentType(func.getLstOperands().get(0), newType, minMax) & this.changeExprentType(func.getLstOperands().get(1), newType, minMax);
                    }
                }
            }
        }
        return res;
    }

    public Map<VarVersionPair, VarType> getMapExprentMaxTypes() {
        return this.mapExprentMaxTypes;
    }

    public Map<VarVersionPair, VarType> getMapExprentMinTypes() {
        return this.mapExprentMinTypes;
    }

    public Map<VarVersionPair, Integer> getMapFinalVars() {
        return this.mapFinalVars;
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.mapExprentMinTypes.put(pair, type);
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.mapExprentMinTypes.get(pair);
    }
}

