/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextUtil;

public class InvocationExprent
extends Exprent {
    public static final int INVOKE_SPECIAL = 1;
    public static final int INVOKE_VIRTUAL = 2;
    public static final int INVOKE_STATIC = 3;
    public static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYP_GENERAL = 1;
    public static final int TYP_INIT = 2;
    public static final int TYP_CLINIT = 3;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private String name;
    private String classname;
    private boolean isStatic;
    private int functype = 1;
    private Exprent instance;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private int invocationTyp = 2;
    private List<Exprent> lstParameters = new ArrayList<Exprent>();
    private List<PooledConstant> bootstrapArguments;

    public InvocationExprent() {
        super(8);
    }

    public InvocationExprent(int opcode, LinkConstant cn, List<PooledConstant> bootstrapArguments, ListStack<Exprent> stack, Set<Integer> bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.classname = cn.classname;
        this.bootstrapArguments = bootstrapArguments;
        switch (opcode) {
            case 184: {
                this.invocationTyp = 3;
                break;
            }
            case 183: {
                this.invocationTyp = 1;
                break;
            }
            case 182: {
                this.invocationTyp = 2;
                break;
            }
            case 185: {
                this.invocationTyp = 4;
                break;
            }
            case 186: {
                this.invocationTyp = 5;
                this.classname = "java/lang/Class";
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.functype = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.functype = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (VarType ignored : this.descriptor.params) {
            this.lstParameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            PooledConstant link;
            int dynamicInvocationType = -1;
            if (bootstrapArguments != null && bootstrapArguments.size() > 1 && (link = bootstrapArguments.get(1)) instanceof LinkConstant) {
                dynamicInvocationType = ((LinkConstant)link).index1;
            }
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.lstParameters.isEmpty()) {
                this.instance = this.lstParameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.classname = expr.getClassname();
        this.isStatic = expr.isStatic();
        this.functype = expr.getFunctype();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationTyp = expr.getInvocationTyp();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        this.lstParameters = new ArrayList<Exprent>(expr.getLstParameters());
        ExprProcessor.copyEntries(this.lstParameters);
        this.addBytecodeOffsets(expr.bytecode);
        this.bootstrapArguments = expr.getBootstrapArguments();
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            Exprent parameter = this.lstParameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.typeFamily));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.lstParameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        int start;
        ClassesProcessor.ClassNode newNode;
        TextBuffer buf = new TextBuffer();
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.isStatic) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
            }
        } else {
            if (this.instance != null && this.instance.type == 12) {
                MethodWrapper currentMethod;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair varPair = new VarVersionPair(instVar);
                VarProcessor varProc = instVar.getProcessor();
                if (varProc == null && (currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                    varProc = currentMethod.varproc;
                }
                String this_classname = null;
                if (varProc != null) {
                    this_classname = varProc.getThisVars().get(varPair);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationTyp == 1 && !this.classname.equals(this_classname)) {
                        super_qualifier = this_classname;
                    }
                }
            }
            if (this.functype == 1) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    TextBuffer res = this.instance.toJava(indent, tracer);
                    VarType rightType = this.instance.getExprType();
                    VarType leftType = new VarType(8, 0, this.classname);
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(leftType)).append(")");
                        if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                            res.enclose("(", ")");
                        }
                        buf.append(res).append(")");
                    } else if (this.instance.getPrecedence() > this.getPrecedence()) {
                        buf.append("(").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                }
            }
        }
        switch (this.functype) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new TextBuffer();
                }
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(this.name);
                if (this.invocationTyp == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        List<VarVersionPair> sigFields = null;
        boolean isEnum = false;
        if (this.functype == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname)) != null) {
            if (newNode.getWrapper() != null) {
                sigFields = newNode.getWrapper().getMethodWrapper((String)"<init>", (String)this.stringDescriptor).signatureFields;
            } else if (newNode.type == 1 && (newNode.access & 8) == 0) {
                sigFields = new ArrayList<VarVersionPair>(Collections.nCopies(this.lstParameters.size(), null));
                sigFields.set(0, new VarVersionPair(-1, 0));
            }
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        BitSet setAmbiguousParameters = this.getAmbiguousParameters();
        boolean firstParameter = true;
        for (int i = start = isEnum ? 2 : 0; i < this.lstParameters.size(); ++i) {
            if (sigFields != null && sigFields.get(i) != null) continue;
            if (!firstParameter) {
                buf.append(", ");
            }
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            ExprProcessor.getCastedExprent(this.lstParameters.get(i), this.descriptor.params[i], buff, indent, true, ambiguous, tracer);
            buf.append(buff);
            firstParameter = false;
        }
        buf.append(")");
        return buf;
    }

    private BitSet getAmbiguousParameters() {
        int i;
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null) {
            return EMPTY_BIT_SET;
        }
        ArrayList<MethodDescriptor> matches = new ArrayList<MethodDescriptor>();
        block0: for (StructMethod mt : cl.getMethods()) {
            if (!this.name.equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length != this.descriptor.params.length) continue;
            for (i = 0; i < md.params.length; ++i) {
                if (md.params[i].typeFamily != this.descriptor.params[i].typeFamily) continue block0;
            }
            matches.add(md);
        }
        if (matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.lstParameters.size()) {
                boolean exact = true;
                for (i = 0; i < md.params.length; ++i) {
                    if (md.params[i].equals(this.lstParameters.get(i).getExprType())) continue;
                    exact = false;
                    break;
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block3: for (int i2 = 0; i2 < this.descriptor.params.length; ++i2) {
            VarType paramType = this.descriptor.params[i2];
            for (MethodDescriptor md : matches) {
                if (paramType.equals(md.params[i2])) continue;
                ambiguous.set(i2);
                continue block3;
            }
        }
        return ambiguous;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            if (oldExpr != this.lstParameters.get(i)) continue;
            this.lstParameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return InterpreterUtil.equalObjects(this.name, it.getName()) && InterpreterUtil.equalObjects(this.classname, it.getClassname()) && this.isStatic == it.isStatic() && InterpreterUtil.equalObjects(this.instance, it.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, it.getDescriptor()) && this.functype == it.getFunctype() && InterpreterUtil.equalLists(this.lstParameters, it.getLstParameters());
    }

    public List<Exprent> getLstParameters() {
        return this.lstParameters;
    }

    public void setLstParameters(List<Exprent> lstParameters) {
        this.lstParameters = lstParameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public int getFunctype() {
        return this.functype;
    }

    public void setFunctype(int functype) {
        this.functype = functype;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationTyp() {
        return this.invocationTyp;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    public List<PooledConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER ? value.isVariable() && (value.parameter >= this.lstParameters.size() || !engine.checkAndSetVariableValue(value.value.toString(), this.lstParameters.get(value.parameter))) : (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS ? !value.value.equals(this.classname) : key == IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE && !value.value.equals(this.name + this.stringDescriptor)))) continue;
            return false;
        }
        return true;
    }
}

