/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPreservingProcess {
    private static final Logger LOG = Logger.getInstance(GitPreservingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<VirtualFile> myRootsToSave;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final String myDestinationName;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Runnable myOperation;
    @NotNull
    private final String myStashMessage;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final AtomicBoolean myLoaded;

    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull String destinationName, @NotNull GitVcsSettings.UpdateChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToSave", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (destinationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationName", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (saveMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveMethod", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        this.myLoaded = new AtomicBoolean();
        this.myProject = project;
        this.myGit = git;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myDestinationName = destinationName;
        this.myProgressIndicator = indicator;
        this.myOperation = operation;
        this.myStashMessage = String.format("Uncommitted changes before %s at %s", StringUtil.capitalize((String)this.myOperationTitle), DateFormatUtil.formatDateTime((long)Clock.getTime()));
        this.mySaver = this.configureSaver(saveMethod);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(final @Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = new Runnable(){

            @Override
            public void run() {
                LOG.debug("starting");
                boolean savedSuccessfully = GitPreservingProcess.this.save();
                LOG.debug("save result: " + savedSuccessfully);
                if (savedSuccessfully) {
                    try {
                        LOG.debug("running operation");
                        GitPreservingProcess.this.myOperation.run();
                        LOG.debug("operation completed.");
                    }
                    finally {
                        if (autoLoadDecision == null || ((Boolean)autoLoadDecision.compute()).booleanValue()) {
                            LOG.debug("loading");
                            GitPreservingProcess.this.load();
                        } else {
                            GitPreservingProcess.this.mySaver.notifyLocalChangesAreNotRestored();
                        }
                    }
                }
                LOG.debug("finished.");
            }
        };
        new GitFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    @NotNull
    private GitChangesSaver configureSaver(@NotNull GitVcsSettings.UpdateChangesPolicy saveMethod) {
        if (saveMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveMethod", "git4idea/util/GitPreservingProcess", "configureSaver"));
        }
        GitChangesSaver saver = GitChangesSaver.getSaver(this.myProject, this.myGit, this.myProgressIndicator, this.myStashMessage, saveMethod);
        MergeDialogCustomizer mergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/util/GitPreservingProcess$2", "getMultipleFileMergeDescription"));
                }
                return String.format("<html>Uncommitted changes that were saved before %s have conflicts with files from <code>%s</code></html>", GitPreservingProcess.this.myOperationTitle, GitPreservingProcess.this.myDestinationName);
            }

            public String getLeftPanelTitle(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/util/GitPreservingProcess$2", "getLeftPanelTitle"));
                }
                return "Uncommitted changes from stash";
            }

            public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/util/GitPreservingProcess$2", "getRightPanelTitle"));
                }
                return String.format("<html>Changes from <b><code>%s</code></b></html>", GitPreservingProcess.this.myDestinationName);
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer).setErrorNotificationTitle("Local changes were not restored");
        saver.setConflictResolverParams(params);
        GitChangesSaver gitChangesSaver = saver;
        if (gitChangesSaver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitPreservingProcess", "configureSaver"));
        }
        return gitChangesSaver;
    }

    private boolean save() {
        try {
            this.mySaver.saveLocalChanges(this.myRootsToSave);
            return true;
        }
        catch (VcsException e) {
            LOG.info("Couldn't save local changes", (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't save uncommitted changes.", String.format("Tried to save uncommitted changes in stash before %s, but failed with an error.<br/>%s", this.myOperationTitle, StringUtil.join((String[])e.getMessages())));
            return false;
        }
    }

    public void load() {
        if (this.myLoaded.compareAndSet(false, true)) {
            this.mySaver.load();
        } else {
            LOG.warn("The changes were already loaded", new Throwable());
        }
    }
}

