/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import git4idea.util.GitCommitCompareInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class GitCompareBranchesDiffPanel
extends JPanel {
    private final Project myProject;
    private final String myBranchName;
    private final String myCurrentBranchName;
    private final GitCommitCompareInfo myCompareInfo;

    public GitCompareBranchesDiffPanel(Project project, String branchName, String currentBranchName, GitCommitCompareInfo compareInfo) {
        this.myProject = project;
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myBranchName = branchName;
        this.setLayout(new BorderLayout(4, 10));
        this.add((Component)this.createNorthPanel(), "North");
        this.add(this.createCenterPanel());
    }

    private JComponent createNorthPanel() {
        return new JBLabel(String.format("<html>Difference between current working tree on <b><code>%s</code></b> and files in <b><code>%s</code></b>:</html>", this.myCurrentBranchName, this.myBranchName), UIUtil.ComponentStyle.REGULAR);
    }

    private JComponent createCenterPanel() {
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, diff, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(diff);
        return changesBrowser;
    }
}

