/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitShelveUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitShelveChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitShelveChangesSaver.class);
    private final ShelveChangesManager myShelveManager;
    private final ShelvedChangesViewManager myShelveViewManager;
    private final ProjectLevelVcsManager myVcsManager;
    private Map<String, ShelvedChangeList> myShelvedLists;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, String stashMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/stash/GitShelveChangesSaver", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/stash/GitShelveChangesSaver", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/stash/GitShelveChangesSaver", "<init>"));
        }
        super(project, git, indicator, stashMessage);
        this.myShelveManager = ShelveChangesManager.getInstance((Project)this.myProject);
        this.myShelveViewManager = ShelvedChangesViewManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void save(@NotNull Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToSave", "git4idea/stash/GitShelveChangesSaver", "save"));
        }
        LOG.info("save " + rootsToSave);
        Map lists = new LocalChangesUnderRoots((ChangeListManager)this.myChangeManager, this.myVcsManager).getChangesByLists(rootsToSave);
        String oldProgressTitle = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(GitBundle.getString("update.shelving.changes"));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>(1);
        this.myShelvedLists = new HashMap<String, ShelvedChangeList>();
        for (Map.Entry entry : lists.entrySet()) {
            Map map = (Map)entry.getValue();
            HashSet<Change> changes = new HashSet<Change>();
            for (Collection changeCollection : map.values()) {
                changes.addAll(changeCollection);
            }
            if (changes.isEmpty()) continue;
            ShelvedChangeList list = GitShelveUtils.shelveChanges(this.myProject, this.myShelveManager, changes, this.myStashMessage + " [" + (String)entry.getKey() + "]", exceptions, false, true);
            this.myShelvedLists.put((String)entry.getKey(), list);
        }
        if (!exceptions.isEmpty()) {
            LOG.info("save " + exceptions, (Throwable)exceptions.get(0));
            this.myShelvedLists = null;
            throw (VcsException)((Object)exceptions.get(0));
        }
        for (VirtualFile root : rootsToSave) {
            GitRollbackEnvironment.resetHardLocal(this.myProject, root);
        }
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    @Override
    public void load() {
        if (this.myShelvedLists != null) {
            LOG.info("load ");
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(GitBundle.getString("update.unshelving.changes"));
            for (ShelvedChangeList list : this.myShelvedLists.values()) {
                GitShelveUtils.doSystemUnshelve(this.myProject, list, this.myShelveManager, GitShelveChangesSaver.getConflictLeftPanelTitle(), GitShelveChangesSaver.getConflictRightPanelTitle());
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    @Override
    public boolean wereChangesSaved() {
        return this.myShelvedLists != null && !this.myShelvedLists.isEmpty();
    }

    @Override
    public String getSaverName() {
        return "shelf";
    }

    @Override
    @NotNull
    public String getOperationName() {
        if ("shelve" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/stash/GitShelveChangesSaver", "getOperationName"));
        }
        return "shelve";
    }

    @Override
    public void showSavedChanges() {
        this.myShelveViewManager.activateView(this.myShelvedLists.get(this.myShelvedLists.keySet().iterator().next()));
    }

    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myShelvedLists;
    }
}

