/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitOutgoingCommitsProvider;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTagPanel;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetPanel;
import git4idea.push.GitPusher;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushSupport
extends PushSupport<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final Pusher<GitRepository, GitPushSource, GitPushTarget> myPusher;
    @NotNull
    private final OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> myOutgoingCommitsProvider;
    @NotNull
    private final GitVcsSettings mySettings;
    private final GitSharedSettings mySharedSettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    private GitPushSupport(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/push/GitPushSupport", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/push/GitPushSupport", "<init>"));
        }
        this.myRepositoryManager = repositoryManager;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myPusher = new GitPusher(project, this.mySettings, this);
        this.myOutgoingCommitsProvider = new GitOutgoingCommitsProvider(project);
        this.mySharedSettings = (GitSharedSettings)ServiceManager.getService((Project)project, GitSharedSettings.class);
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "getVcs"));
        }
        return gitVcs;
    }

    @NotNull
    public Pusher<GitRepository, GitPushSource, GitPushTarget> getPusher() {
        Pusher<GitRepository, GitPushSource, GitPushTarget> pusher = this.myPusher;
        if (pusher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "getPusher"));
        }
        return pusher;
    }

    @NotNull
    public OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> getOutgoingCommitsProvider() {
        OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> outgoingCommitsProvider = this.myOutgoingCommitsProvider;
        if (outgoingCommitsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "getOutgoingCommitsProvider"));
        }
        return outgoingCommitsProvider;
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushSupport", "getDefaultTarget"));
        }
        if (repository.isFresh()) {
            return null;
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitPushTarget persistedTarget = this.getPersistedTarget(repository, currentBranch);
        if (persistedTarget != null) {
            return persistedTarget;
        }
        GitPushTarget pushSpecTarget = GitPushTarget.getFromPushSpec(repository, currentBranch);
        if (pushSpecTarget != null) {
            return pushSpecTarget;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
        if (trackInfo != null) {
            return new GitPushTarget(trackInfo.getRemoteBranch(), false);
        }
        return GitPushSupport.proposeTargetForNewBranch(repository, currentBranch);
    }

    @Nullable
    private GitPushTarget getPersistedTarget(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushSupport", "getPersistedTarget"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/push/GitPushSupport", "getPersistedTarget"));
        }
        GitRemoteBranch target = this.mySettings.getPushTarget(repository, branch.getName());
        return target == null ? null : new GitPushTarget(target, !repository.getBranches().getRemoteBranches().contains(target));
    }

    private static GitPushTarget proposeTargetForNewBranch(GitRepository repository, GitLocalBranch currentBranch) {
        Collection<GitRemote> remotes = repository.getRemotes();
        if (remotes.isEmpty()) {
            return null;
        }
        if (remotes.size() == 1) {
            return GitPushSupport.makeTargetForNewBranch(repository, remotes.iterator().next(), currentBranch);
        }
        GitRemote remote = GitUtil.getDefaultRemote(remotes);
        if (remote == null) {
            remote = remotes.iterator().next();
        }
        return GitPushSupport.makeTargetForNewBranch(repository, remote, currentBranch);
    }

    @NotNull
    private static GitPushTarget makeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch currentBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushSupport", "makeTargetForNewBranch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/push/GitPushSupport", "makeTargetForNewBranch"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "git4idea/push/GitPushSupport", "makeTargetForNewBranch"));
        }
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, currentBranch.getName());
        if (existingRemoteBranch != null) {
            GitPushTarget gitPushTarget = new GitPushTarget(existingRemoteBranch, false);
            if (gitPushTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "makeTargetForNewBranch"));
            }
            return gitPushTarget;
        }
        GitPushTarget gitPushTarget = new GitPushTarget(new GitStandardRemoteBranch(remote, currentBranch.getName()), true);
        if (gitPushTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "makeTargetForNewBranch"));
        }
        return gitPushTarget;
    }

    @NotNull
    public GitPushSource getSource(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushSupport", "getSource"));
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        GitPushSource gitPushSource = currentBranch != null ? GitPushSource.create(currentBranch) : GitPushSource.create((String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision()));
        if (gitPushSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "getSource"));
        }
        return gitPushSource;
    }

    @NotNull
    public RepositoryManager<GitRepository> getRepositoryManager() {
        GitRepositoryManager gitRepositoryManager = this.myRepositoryManager;
        if (gitRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "getRepositoryManager"));
        }
        return gitRepositoryManager;
    }

    @NotNull
    public PushTargetPanel<GitPushTarget> createTargetPanel(@NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushSupport", "createTargetPanel"));
        }
        GitPushTargetPanel gitPushTargetPanel = new GitPushTargetPanel(this, repository, defaultTarget);
        if (gitPushTargetPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSupport", "createTargetPanel"));
        }
        return gitPushTargetPanel;
    }

    public boolean isForcePushAllowed(@NotNull GitRepository repo, @NotNull GitPushTarget target) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "git4idea/push/GitPushSupport", "isForcePushAllowed"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/push/GitPushSupport", "isForcePushAllowed"));
        }
        String targetBranch = target.getBranch().getNameForRemoteOperations();
        return !this.mySharedSettings.isBranchProtected(targetBranch);
    }

    public boolean isForcePushEnabled() {
        return this.mySettings.isForcePushAllowed();
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new GitPushTagPanel(this.mySettings.getPushTagMode(), GitVersionSpecialty.SUPPORTS_FOLLOW_TAGS.existsIn(this.myVcs.getVersion()));
    }

    public boolean isSilentForcePushAllowed(@NotNull GitPushTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/push/GitPushSupport", "isSilentForcePushAllowed"));
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public void saveSilentForcePushTarget(@NotNull GitPushTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/push/GitPushSupport", "saveSilentForcePushTarget"));
        }
        this.myCommonPushSettings.addForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public boolean mayChangeTargetsSync() {
        return true;
    }
}

